/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.kmeans;

import org.encog.ml.kmeans.KMeansCluster;

public class Centroid {
    private final double[] centers;
    private KMeansCluster cluster;

    public Centroid(double[] theCenters) {
        this.centers = theCenters;
    }

    public final void calcCentroid() {
        int i;
        int numDP = this.cluster.size();
        double[] temp = new double[this.centers.length];
        for (i = 0; i < numDP; ++i) {
            for (int j = 0; j < temp.length; ++j) {
                int n = j;
                temp[n] = temp[n] + this.cluster.get(i).getData(j);
            }
        }
        for (i = 0; i < temp.length; ++i) {
            this.centers[i] = temp[i] / (double)numDP;
        }
        this.cluster.calcSumOfSquares();
    }

    public final double[] getCenters() {
        return this.centers;
    }

    public final KMeansCluster getCluster() {
        return this.cluster;
    }

    public final void setCluster(KMeansCluster c) {
        this.cluster = c;
    }
}

