/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.flat.train.prop;

import org.encog.ml.data.MLDataSet;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.flat.train.prop.TrainFlatNetworkProp;

public class TrainFlatNetworkManhattan
extends TrainFlatNetworkProp {
    private final double zeroTolerance;
    private double learningRate;

    public TrainFlatNetworkManhattan(FlatNetwork network, MLDataSet training, double theLearningRate) {
        super(network, training);
        this.learningRate = theLearningRate;
        this.zeroTolerance = 1.0E-17;
    }

    public final double getLearningRate() {
        return this.learningRate;
    }

    public final void setLearningRate(double theLearningRate) {
        this.learningRate = theLearningRate;
    }

    @Override
    public final double updateWeight(double[] gradients, double[] lastGradient, int index) {
        if (Math.abs(gradients[index]) < this.zeroTolerance) {
            return 0.0;
        }
        if (gradients[index] > 0.0) {
            return this.learningRate;
        }
        return -this.learningRate;
    }

    @Override
    public void initOthers() {
    }
}

