/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ml.shifu.guagua.GuaguaRuntimeException;

public final class ReflectionUtils {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();

    private ReflectionUtils() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(clazz);
            if (meth == null) {
                meth = clazz.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(clazz, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T newInstance(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            return (T)ReflectionUtils.newInstance(clazz);
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException(e);
        }
    }
}

