/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.GuaguaRecordReader;
import ml.shifu.guagua.worker.WorkerComputable;
import ml.shifu.guagua.worker.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkerComputable<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable, KEY extends Bytable, VALUE extends Bytable>
implements WorkerComputable<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWorkerComputable.class);
    private AtomicBoolean isLoaded = new AtomicBoolean(false);
    private GuaguaRecordReader<KEY, VALUE> recordReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WORKER_RESULT compute(WorkerContext<MASTER_RESULT, WORKER_RESULT> workerContext) throws IOException {
        WORKER_RESULT WORKER_RESULT;
        long start;
        if (this.isLoaded.compareAndSet(false, true)) {
            this.init(workerContext);
            start = System.nanoTime();
            this.preLoad(workerContext);
            long count = 0L;
            for (GuaguaFileSplit fileSplit : workerContext.getFileSplits()) {
                LOG.info("Loading filesplit: {}", (Object)fileSplit);
                try {
                    this.initRecordReader(fileSplit);
                    while (this.getRecordReader().nextKeyValue()) {
                        this.load(this.getRecordReader().getCurrentKey(), this.getRecordReader().getCurrentValue(), workerContext);
                        ++count;
                    }
                }
                finally {
                    if (this.getRecordReader() == null) continue;
                    this.getRecordReader().close();
                }
            }
            this.postLoad(workerContext);
            LOG.info("Load {} records.", (Object)count);
            LOG.info("Data loading time:{}ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        start = System.nanoTime();
        try {
            WORKER_RESULT = this.doCompute(workerContext);
        }
        catch (Throwable throwable) {
            LOG.info("Computation time for application {} container {} iteration {}: {}ms.", new Object[]{workerContext.getAppId(), workerContext.getContainerId(), workerContext.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
            throw throwable;
        }
        LOG.info("Computation time for application {} container {} iteration {}: {}ms.", new Object[]{workerContext.getAppId(), workerContext.getContainerId(), workerContext.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
        return WORKER_RESULT;
    }

    protected void preLoad(WorkerContext<MASTER_RESULT, WORKER_RESULT> workerContext) {
    }

    protected void postLoad(WorkerContext<MASTER_RESULT, WORKER_RESULT> workerContext) {
    }

    public abstract void initRecordReader(GuaguaFileSplit var1) throws IOException;

    public abstract void init(WorkerContext<MASTER_RESULT, WORKER_RESULT> var1);

    public abstract WORKER_RESULT doCompute(WorkerContext<MASTER_RESULT, WORKER_RESULT> var1);

    public abstract void load(KEY var1, VALUE var2, WorkerContext<MASTER_RESULT, WORKER_RESULT> var3);

    public GuaguaRecordReader<KEY, VALUE> getRecordReader() {
        return this.recordReader;
    }

    public void setRecordReader(GuaguaRecordReader<KEY, VALUE> recordReader) {
        this.recordReader = recordReader;
    }
}

