/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.worker.AbstractWorkerCoordinator;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWorkerCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends AbstractWorkerCoordinator<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncWorkerCoordinator.class);

    @Override
    public void preApplication(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.initialize(context.getProps());
        new AbstractWorkerCoordinator.FailOverCoordinatorCommand(context).execute();
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appId = context.getAppId();
                int currentIteration = context.getCurrentIteration();
                String containerId = context.getContainerId();
                final String appMasterNode = SyncWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                Stat stat = null;
                String znode = null;
                try {
                    znode = SyncWorkerCoordinator.this.getRootNode().toString();
                    stat = SyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        SyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = SyncWorkerCoordinator.this.getAppNode(appId).toString();
                    stat = SyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        SyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = SyncWorkerCoordinator.this.getWorkerBaseNode(appId).toString();
                    stat = SyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        SyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = SyncWorkerCoordinator.this.getWorkerBaseNode(appId, currentIteration).toString();
                    stat = SyncWorkerCoordinator.this.getZooKeeper().exists(znode, false);
                    if (stat == null) {
                        SyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                try {
                    znode = SyncWorkerCoordinator.this.getCurrentWorkerNode(appId, containerId, currentIteration).toString();
                    SyncWorkerCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Has such node:{}", (Object)znode);
                }
                new BasicCoordinator.RetryCoordinatorCommand(SyncWorkerCoordinator.this.isFixedTime(), SyncWorkerCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        try {
                            return SyncWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, false) != null;
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 10L == 0L) {
                                LOG.warn("No such node:{}", (Object)appMasterNode);
                            }
                            return false;
                        }
                    }
                }.execute();
                if (context.getCurrentIteration() != 0) {
                    String appMasterSplitNode = SyncWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                    SyncWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                }
                LOG.info("Master initilization is done.");
            }
        }.execute();
    }

    @Override
    public void postIteration(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appMasterNode;
                int currentIteration;
                String appId;
                block6: {
                    appId = context.getAppId();
                    String containerId = context.getContainerId();
                    currentIteration = context.getCurrentIteration();
                    appMasterNode = SyncWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                    String appWorkerNode = SyncWorkerCoordinator.this.getCurrentWorkerNode(appId, containerId, currentIteration).toString();
                    String appWorkerSplitNode = SyncWorkerCoordinator.this.getCurrentWorkerSplitNode(appId, containerId, currentIteration).toString();
                    boolean isSplit = false;
                    try {
                        byte[] bytes = SyncWorkerCoordinator.this.getWorkerSerializer().objectToBytes(context.getWorkerResult());
                        isSplit = SyncWorkerCoordinator.this.setBytesToZNode(appWorkerNode, appWorkerSplitNode, bytes, CreateMode.PERSISTENT);
                    }
                    catch (KeeperException.NodeExistsException e) {
                        LOG.warn("Has such node:{}", (Object)appWorkerNode);
                    }
                    if (context.getCurrentIteration() >= 1) {
                        String znode = SyncWorkerCoordinator.this.getWorkerNode(appId, containerId, currentIteration - 1).toString();
                        try {
                            SyncWorkerCoordinator.this.getZooKeeper().deleteExt(znode, -1, false);
                            if (isSplit) {
                                znode = SyncWorkerCoordinator.this.getCurrentWorkerSplitNode(appId, containerId, currentIteration - 1).toString();
                                SyncWorkerCoordinator.this.getZooKeeper().deleteExt(znode, -1, true);
                            }
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 20L != 0L) break block6;
                            LOG.warn("No such node:{}", (Object)znode);
                        }
                    }
                }
                long start = System.nanoTime();
                new BasicCoordinator.RetryCoordinatorCommand(SyncWorkerCoordinator.this.isFixedTime(), SyncWorkerCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        try {
                            return SyncWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, false) != null;
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 10L == 0L) {
                                LOG.warn("No such node:{}", (Object)appMasterNode);
                            }
                            return false;
                        }
                    }
                }.execute();
                LOG.info("Application {} container {} iteration {} waiting ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
                String appMasterSplitNode = SyncWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                SyncWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                LOG.info("Master computation is done.");
            }
        }.execute();
    }
}

