/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua;

import java.util.ArrayList;
import java.util.List;
import ml.shifu.guagua.io.Bytable;

public class InMemoryCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable> {
    private static final int DEFAULT_SLEEP_TIME = 300;
    private final int workers;
    private MASTER_RESULT masterResult;
    private List<WORKER_RESULT> workerResults;
    private List<Integer> workerCounts;
    private List<Integer> masterCounts;

    public InMemoryCoordinator(int workers, int iteration) {
        int i;
        this.workers = workers;
        int maxIteration = iteration + 1;
        this.workerCounts = new ArrayList<Integer>(maxIteration);
        this.masterCounts = new ArrayList<Integer>(maxIteration);
        for (i = 0; i < maxIteration; ++i) {
            this.workerCounts.add(this.workers);
            this.masterCounts.add(1);
        }
        this.workerResults = new ArrayList<WORKER_RESULT>(this.workers);
        for (i = 0; i < this.workers; ++i) {
            this.workerResults.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWorkers(int iteration) {
        int currentCount = 0;
        while (true) {
            List<Integer> list = this.workerCounts;
            synchronized (list) {
                currentCount = this.workerCounts.get(iteration);
            }
            if (currentCount == 0) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalMaster(int iteration, int containerIndex, WORKER_RESULT workerResult) {
        List<Integer> list = this.workerCounts;
        synchronized (list) {
            this.workerCounts.set(iteration, this.workerCounts.get(iteration) - 1);
            if (workerResult != null) {
                this.workerResults.set(containerIndex, workerResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitMaster(int iteration) {
        int currentCount = 0;
        while (true) {
            List<Integer> list = this.masterCounts;
            synchronized (list) {
                currentCount = this.masterCounts.get(iteration);
            }
            if (currentCount == 0) break;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalWorkers(int iteration, MASTER_RESULT masterResult) {
        List<Integer> list = this.masterCounts;
        synchronized (list) {
            this.masterCounts.set(iteration, this.masterCounts.get(iteration) - 1);
            this.masterResult = masterResult;
        }
    }

    public MASTER_RESULT getMasterResult() {
        return this.masterResult;
    }

    public List<WORKER_RESULT> getWorkerResults() {
        return new ArrayList<WORKER_RESULT>(this.workerResults);
    }
}

