/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.coordinator.zk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import ml.shifu.guagua.util.FileUtils;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

public final class ZooKeeperUtils {
    private static final int DEFAULT_ZK_PORT = 2181;
    public static final int RETRY_COUNT = 4;
    public static final int TRY_PORT_COUNT = 20;
    public static final int INITAL_ZK_PORT = -1;

    private ZooKeeperUtils() {
    }

    public static int getValidZooKeeperPort() {
        int zkValidPort = -1;
        for (int i = 2181; i < 2201; ++i) {
            try {
                if (ZooKeeperUtils.isServerAlive(InetAddress.getLocalHost(), i)) continue;
                zkValidPort = i;
                break;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        if (zkValidPort == -1) {
            throw new RuntimeException("Too many ports are used, please submit guagua app later or specify one zookeeper instance.");
        }
        return zkValidPort;
    }

    public static void populateZooKeeperConfFile(String fileName, Map<String, String> props) {
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)outputStream, "utf-8");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                writer.write(entry.getKey() + "=" + entry.getValue());
                writer.write(System.getProperty("line.separator"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerAlive(InetAddress host, int port) {
        Socket socket = null;
        int i = 0;
        while (i < 4) {
            try {
                socket = new Socket(host, port);
                break;
            }
            catch (IOException e) {
                ++i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException ignore) {}
            }
        }
        return i != 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerAlive(String host, int port) {
        Socket socket = null;
        int i = 0;
        while (i++ < 4) {
            try {
                socket = new Socket(host, port);
                break;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException ignore) {}
            }
        }
        return i == 4;
    }

    private static void createFolder(String folder) {
        File file = new File(folder);
        if (file.exists()) {
            file.delete();
        }
        file.mkdir();
    }

    public static void prepZooKeeperConf(String fileName, String clientPort) {
        HashMap<String, String> props = new HashMap<String, String>();
        String dataDir = ZooKeeperUtils.getZooKeeperWorkingDir() + File.separator + "zkdata";
        ZooKeeperUtils.createFolder(dataDir);
        String dataLogDir = ZooKeeperUtils.getZooKeeperWorkingDir() + File.separator + "zklog";
        ZooKeeperUtils.createFolder(dataLogDir);
        props.put("tickTime", "2000");
        props.put("initLimit", "10");
        props.put("syncLimit", "5");
        props.put("dataDir", dataDir);
        props.put("dataLogDir", dataLogDir);
        props.put("clientPort", clientPort);
        props.put("minSessionTimeout", "10000");
        props.put("maxSessionTimeout", "30000000");
        ZooKeeperUtils.populateZooKeeperConfFile(fileName, props);
    }

    private static String getUserDir() {
        return System.getProperty("user.dir");
    }

    private static String getZooKeeperWorkingDir() {
        return ZooKeeperUtils.getUserDir() + File.separator + "zookeeper";
    }

    public static void checkIfEmbedZooKeeperStarted(int embedZkClientPort) {
        try {
            int i = 0;
            while (i++ < 4 && !ZooKeeperUtils.isServerAlive(InetAddress.getLocalHost(), embedZkClientPort)) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                System.err.println("INFO: Waiting embed server to start.");
            }
            if (i == 4) {
                throw new RuntimeException("Exception to start embed, please specified zookeeper server by -z");
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static int startEmbedZooKeeper() {
        final String zooKeeperWorkingDir = ZooKeeperUtils.getZooKeeperWorkingDir();
        ZooKeeperUtils.createFolder(zooKeeperWorkingDir);
        final String confName = zooKeeperWorkingDir + File.separator + "zoo.cfg";
        int validZkPort = ZooKeeperUtils.getValidZooKeeperPort();
        ZooKeeperUtils.prepZooKeeperConf(confName, validZkPort + "");
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                QuorumPeerMain.main((String[])new String[]{confName});
            }
        }, "Embed ZooKeeper");
        thread.setDaemon(true);
        thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteDirectory(new File(zooKeeperWorkingDir));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }));
        return validZkPort;
    }

    public static boolean checkServers(String servers) {
        String[] serverArray;
        for (String server : serverArray = servers.split(",")) {
            if (server == null) continue;
            server = server.trim();
            String port = null;
            String host = null;
            if (server.indexOf(58) > 0) {
                String[] hostAndPort = server.split(":");
                host = hostAndPort[0].trim();
                port = hostAndPort[1].trim();
            } else {
                host = server;
            }
            if (!ZooKeeperUtils.isServerAlive(host, Integer.parseInt(port))) continue;
            return true;
        }
        return false;
    }
}

