/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

public final class NumberFormatUtils {
    private NumberFormatUtils() {
    }

    public static int getInt(String str, int defaultValue) {
        return NumberFormatUtils.getInt(str, false, defaultValue);
    }

    public static int getInt(String str) {
        return NumberFormatUtils.getInt(str, false, 0);
    }

    public static int getInt(String str, boolean required) {
        return NumberFormatUtils.getInt(str, required, 0);
    }

    public static int getInt(String str, boolean required, int defaultValue) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            if (required) {
                throw new IllegalArgumentException("Not a valid input", e);
            }
            return defaultValue;
        }
    }

    public static long getLong(String str, long defaultValue) {
        return NumberFormatUtils.getLong(str, false, defaultValue);
    }

    public static long getLong(String str) {
        return NumberFormatUtils.getLong(str, false, 0L);
    }

    public static long getLong(String str, boolean required) {
        return NumberFormatUtils.getLong(str, required, 0L);
    }

    public static long getLong(String str, boolean required, long defaultValue) {
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            if (required) {
                throw new IllegalArgumentException("Not a valid input", e);
            }
            return defaultValue;
        }
    }

    public static double getDouble(String str, double defaultValue) {
        return NumberFormatUtils.getDouble(str, false, defaultValue);
    }

    public static double getDouble(String str) {
        return NumberFormatUtils.getDouble(str, false, 0.0);
    }

    public static double getDouble(String str, boolean required) {
        return NumberFormatUtils.getDouble(str, required, 0.0);
    }

    public static double getDouble(String str, boolean required, double defaultValue) {
        try {
            return Double.valueOf(str);
        }
        catch (Exception e) {
            if (required) {
                throw new IllegalArgumentException("Not a valid input", e);
            }
            return defaultValue;
        }
    }
}

