/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import ml.shifu.guagua.InMemoryCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.master.BasicMasterInterceptor;
import ml.shifu.guagua.master.MasterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMasterCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicMasterInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalMasterCoordinator.class);
    private InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator;

    @Override
    public void preApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.coordinator.awaitWorkers(context.getCurrentIteration());
        LOG.info("All workers are initilized.");
        this.coordinator.signalWorkers(context.getCurrentIteration(), null);
    }

    @Override
    public void preIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.coordinator.awaitWorkers(context.getCurrentIteration());
        context.setWorkerResults(this.coordinator.getWorkerResults());
        LOG.info("All workers are synced in iteration {}.", (Object)context.getCurrentIteration());
    }

    @Override
    public void postIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.coordinator.signalWorkers(context.getCurrentIteration(), context.getMasterResult());
    }

    public void setCoordinator(InMemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator) {
        this.coordinator = coordinator;
    }
}

