/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.io;

import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.BytableSerializer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;

public class NettyBytableEncoder
extends ObjectEncoder {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private BytableSerializer<Bytable> serializer;
    private final int estimatedLength;

    public NettyBytableEncoder() {
        this(65536);
    }

    public NettyBytableEncoder(int estimatedLength) {
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        this.estimatedLength = estimatedLength;
        this.serializer = new BytableSerializer();
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof Bytable)) {
            throw new IllegalStateException("Only Bytable message can be encoded.");
        }
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)this.estimatedLength, (ChannelBufferFactory)ctx.getChannel().getConfig().getBufferFactory()));
        bout.write(LENGTH_PLACEHOLDER);
        byte[] classNameBytes = msg.getClass().getName().getBytes("UTF-8");
        bout.writeInt(classNameBytes.length);
        bout.write(classNameBytes);
        bout.write(this.serializer.objectToBytes((Bytable)msg));
        ChannelBuffer encoded = bout.buffer();
        encoded.setInt(0, encoded.writerIndex() - 4);
        return encoded;
    }
}

