/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.BytableSerializer;
import ml.shifu.guagua.util.AppendList;
import ml.shifu.guagua.util.FileUtils;

public class BytableDiskList<T extends Bytable>
implements AppendList<T> {
    private BytableSerializer<T> serializer = new BytableSerializer();
    private DataOutputStream outputStream;
    private DataInputStream inputStream;
    private AppendList.State state = AppendList.State.WRITE;
    private File file;
    private long count;
    private String className;

    public BytableDiskList(String fileName, String className) {
        this(fileName, className, new BytableSerializer());
    }

    public BytableDiskList(String fileName, String className, BytableSerializer<T> serializer) {
        try {
            this.file = new File(fileName);
            this.outputStream = new DataOutputStream(new FileOutputStream(this.file));
            this.inputStream = new DataInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
        this.className = className;
        this.serializer = serializer;
    }

    @Override
    public void switchState() {
        this.state = AppendList.State.READ;
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
    }

    public void reOpen() {
        this.close();
        try {
            this.inputStream = new DataInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
    }

    @Override
    public boolean append(T t) {
        if (this.state != AppendList.State.WRITE) {
            throw new IllegalStateException();
        }
        ++this.count;
        byte[] bytes = this.getSerializer().objectToBytes(t);
        try {
            this.outputStream.writeInt(bytes.length);
            this.outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
        return true;
    }

    public void close() {
        try {
            this.outputStream.close();
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.state != AppendList.State.READ) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return BytableDiskList.this.inputStream.available() > 0;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public T next() {
                try {
                    int length = BytableDiskList.this.inputStream.readInt();
                    byte[] bytes = new byte[length];
                    int size = BytableDiskList.this.inputStream.read(bytes);
                    if (size < 0) {
                        throw new GuaguaRuntimeException("IO exception on reading disk file.");
                    }
                    return BytableDiskList.this.getSerializer().bytesToObject(bytes, BytableDiskList.this.className);
                }
                catch (IOException e) {
                    throw new GuaguaRuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BytableSerializer<T> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(BytableSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public int size() {
        return (int)this.count;
    }

    @Override
    public void clear() {
        FileUtils.deleteQuietly(this.file);
    }
}

