/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

public final class MemoryUtils {
    private MemoryUtils() {
    }

    private static double megaBytes(long bytes) {
        return (double)bytes / 1024.0 / 1024.0;
    }

    public static double totalMemoryMB() {
        return MemoryUtils.megaBytes(Runtime.getRuntime().totalMemory());
    }

    public static double maxMemoryMB() {
        return MemoryUtils.megaBytes(Runtime.getRuntime().maxMemory());
    }

    public static double freeMemoryMB() {
        return MemoryUtils.megaBytes(Runtime.getRuntime().freeMemory());
    }

    public static double usedMemoryMB() {
        return MemoryUtils.megaBytes(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    public static double usedRatio() {
        return (double)Runtime.getRuntime().freeMemory() * 1.0 / (double)Runtime.getRuntime().totalMemory();
    }

    public static String getRuntimeMemoryStats() {
        return String.format("Memory (free/used/total/max) = %.2fM / %.2fM / %.2fM / %.2fM", MemoryUtils.freeMemoryMB(), MemoryUtils.usedMemoryMB(), MemoryUtils.totalMemoryMB(), MemoryUtils.maxMemoryMB());
    }
}

