/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import ml.shifu.guagua.GuaguaRuntimeException;

public final class NetworkUtils {
    public static final int RETRY_COUNT = 3;
    public static final int TRY_PORT_COUNT = 20;
    private static final Random RANDOM = new Random();

    private NetworkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerAlive(String host, int port) {
        Socket socket = null;
        int i = 0;
        while (i < 3) {
            try {
                socket = new Socket(host, port);
                break;
            }
            catch (IOException e) {
                ++i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return i != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerAlive(InetAddress host, int port) {
        Socket socket = null;
        int i = 0;
        while (i < 3) {
            try {
                socket = new Socket(host, port);
                break;
            }
            catch (IOException e) {
                ++i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return i != 3;
    }

    public static int getValidServerPort(int iniatialPort) {
        assert (iniatialPort > 100);
        iniatialPort = System.currentTimeMillis() % 2L == 0L ? (iniatialPort += RANDOM.nextInt(100)) : (iniatialPort -= RANDOM.nextInt(100));
        int zkValidPort = -1;
        for (int i = iniatialPort; i < iniatialPort + 20; ++i) {
            try {
                if (NetworkUtils.isServerAlive(InetAddress.getLocalHost(), i)) continue;
                zkValidPort = i;
                break;
            }
            catch (UnknownHostException e) {
                throw new GuaguaRuntimeException(e);
            }
        }
        if (zkValidPort == -1) {
            throw new GuaguaRuntimeException("Too many ports are used, please submit guagua app later.");
        }
        return zkValidPort;
    }
}

