/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.master.AbstractMasterCoordinator;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.util.NumberFormatUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMasterCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends AbstractMasterCoordinator<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncMasterCoordinator.class);

    @Override
    public void preApplication(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.initialize(context.getProps());
        if (NumberFormatUtils.getInt(context.getProps().getProperty("guagua.master.number"), 1) > 1) {
            new AbstractMasterCoordinator.MasterElectionCommand(context.getAppId()).execute();
        }
        new AbstractMasterCoordinator.FailOverCommand(context).execute();
        if (context.getCurrentIteration() != 0) {
            return;
        }
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appId = context.getAppId();
                int currentIteration = context.getCurrentIteration();
                final String appWorkersNode = SyncMasterCoordinator.this.getWorkerBaseNode(appId, currentIteration).toString();
                final int workers = context.getWorkers();
                new BasicCoordinator.RetryCoordinatorCommand(SyncMasterCoordinator.this.isFixedTime(), SyncMasterCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        try {
                            List<String> childrenExt = SyncMasterCoordinator.this.getZooKeeper().getChildrenExt(appWorkersNode, false, false, false);
                            int initDoneWorkers = childrenExt.size();
                            if (System.nanoTime() % 20L == 0L) {
                                LOG.info("workers already initialized: {}, still {} workers are not synced.", (Object)initDoneWorkers, (Object)(context.getWorkers() - initDoneWorkers));
                                LOG.info("DEBUG: left workers:{}", (Object)SyncMasterCoordinator.notInList(childrenExt, context.getWorkers()));
                            }
                            return this.isTerminated(initDoneWorkers, workers, context.getMinWorkersRatio(), context.getMinWorkersTimeOut());
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 10L == 0L) {
                                LOG.warn("No such node:{}", (Object)appWorkersNode);
                            }
                            return false;
                        }
                    }
                }.execute();
                LOG.info("All workers are initiliazed successfully.");
                String znode = null;
                try {
                    znode = SyncMasterCoordinator.this.getWorkerBaseNode(context.getAppId(), context.getCurrentIteration() + 1).toString();
                    SyncMasterCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    znode = SyncMasterCoordinator.this.getMasterBaseNode(context.getAppId()).toString();
                    SyncMasterCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    znode = SyncMasterCoordinator.this.getCurrentMasterNode(context.getAppId(), context.getCurrentIteration()).toString();
                    SyncMasterCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Node exists: {}", znode);
                }
            }
        }.execute();
    }

    @Override
    public void preIteration(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                final int currentIteration = context.getCurrentIteration();
                final int workers = context.getWorkers();
                final String appCurrentWorkersNode = SyncMasterCoordinator.this.getWorkerBaseNode(context.getAppId(), currentIteration).toString();
                long start = System.nanoTime();
                new BasicCoordinator.RetryCoordinatorCommand(SyncMasterCoordinator.this.isFixedTime(), SyncMasterCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        try {
                            List<String> workerChildern = SyncMasterCoordinator.this.getZooKeeper().getChildrenExt(appCurrentWorkersNode, false, false, false);
                            int workersCompleted = workerChildern.size();
                            if (System.nanoTime() % 20L == 0L) {
                                LOG.info("iteration {}, workers compelted: {}, still {} workers are not synced.", new Object[]{currentIteration, workersCompleted, workers - workersCompleted});
                                LOG.info("DEBUG: left workers:{}", (Object)SyncMasterCoordinator.notInList(workerChildern, context.getWorkers()));
                            }
                            return this.isTerminated(workersCompleted, workers, context.getMinWorkersRatio(), context.getMinWorkersTimeOut());
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 10L == 0L) {
                                LOG.warn("No such node:{}", (Object)appCurrentWorkersNode);
                            }
                            return false;
                        }
                    }
                }.execute();
                LOG.info("Application {} container {} iteration {} waiting ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
                SyncMasterCoordinator.this.setWorkerResults(context, appCurrentWorkersNode, context.getAppId(), currentIteration);
            }
        }.execute();
    }

    private static List<Integer> notInList(List<String> inputs, int num) {
        ArrayList<Integer> set = new ArrayList<Integer>();
        for (int i = 1; i <= num; ++i) {
            set.add(i);
        }
        for (String string : inputs) {
            Integer n = Integer.valueOf(string);
            set.remove(n);
        }
        Collections.sort(set);
        return set;
    }
}

