/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.coordinator.zk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.coordinator.zk.ZooKeeperMain;
import ml.shifu.guagua.util.FileUtils;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.Log4jLoggerAdapter;

public final class ZooKeeperUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperUtils.class);
    private static final int DEFAULT_ZK_PORT = 2181;
    public static final int RETRY_COUNT = 4;
    public static final int TRY_PORT_COUNT = 20;
    public static final int INITAL_ZK_PORT = -1;
    private static final Random RANDOM = new Random();

    private ZooKeeperUtils() {
    }

    public static int getValidZooKeeperPort() {
        int zkValidPort = -1;
        int initialPort = 2181;
        zkValidPort = System.currentTimeMillis() % 2L == 0L ? (zkValidPort += RANDOM.nextInt(100)) : (zkValidPort -= RANDOM.nextInt(100));
        for (int i = initialPort; i < initialPort + 20; ++i) {
            try {
                if (ZooKeeperUtils.isServerAlive(InetAddress.getLocalHost(), i)) continue;
                zkValidPort = i;
                break;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        if (zkValidPort == -1) {
            throw new RuntimeException("Too many ports are used, please submit guagua app later or specify one zookeeper instance.");
        }
        return zkValidPort;
    }

    public static void populateZooKeeperConfFile(String fileName, Map<String, String> props) {
        OutputStreamWriter writer = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                FileUtils.deleteDirectory(file);
            }
            if (!file.createNewFile()) {
                throw new IllegalStateException("Error to create new file " + fileName);
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)outputStream, "utf-8");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                writer.write(entry.getKey() + "=" + entry.getValue());
                writer.write(System.getProperty("line.separator"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerAlive(InetAddress host, int port) {
        Socket socket = null;
        int i = 0;
        while (i < 4) {
            try {
                socket = new Socket(host, port);
                break;
            }
            catch (IOException e) {
                ++i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException ignore) {}
            }
        }
        return i != 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerAlive(String host, int port) {
        Socket socket = null;
        int i = 0;
        while (i++ < 4) {
            try {
                socket = new Socket(host, port);
                break;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException ignore) {}
            }
        }
        return i < 4;
    }

    private static boolean createFolder(String folder) throws IOException {
        File file = new File(folder);
        try {
            FileUtils.deleteDirectory(file);
        }
        catch (IOException ignore) {
            return false;
        }
        return file.mkdir();
    }

    public static void prepZooKeeperConf(String zkFolder, String fileName, String clientPort) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        String dataDir = zkFolder + File.separator + "zkdata";
        ZooKeeperUtils.createFolder(dataDir);
        String dataLogDir = zkFolder + File.separator + "zklog";
        ZooKeeperUtils.createFolder(dataLogDir);
        props.put("tickTime", "2000");
        props.put("initLimit", "10");
        props.put("syncLimit", "5");
        props.put("dataDir", dataDir);
        props.put("dataLogDir", dataLogDir);
        props.put("clientPort", clientPort);
        props.put("minSessionTimeout", "10000");
        props.put("maxSessionTimeout", "30000000");
        props.put("autopurge.snapRetainCount", "3");
        props.put("autopurge.purgeInterval", "1");
        ZooKeeperUtils.populateZooKeeperConfFile(fileName, props);
    }

    private static String getUserDir() {
        return System.getProperty("user.dir");
    }

    private static String getZooKeeperWorkingDir() {
        return ZooKeeperUtils.getUserDir() + File.separator + "zookeeper";
    }

    private static String getZooKeeperWorkingDir(String subFolder) {
        return ZooKeeperUtils.getUserDir() + File.separator + subFolder;
    }

    public static void checkIfEmbedZooKeeperStarted(int embedZkClientPort) {
        try {
            int i = 0;
            while (i++ < 4 && !ZooKeeperUtils.isServerAlive(InetAddress.getLocalHost(), embedZkClientPort)) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                System.err.println("INFO: Waiting embed server to start.");
            }
            if (i == 4) {
                throw new RuntimeException("Exception to start embed, please specified zookeeper server by -z");
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static int startEmbedZooKeeper() throws IOException {
        String zooKeeperWorkingDir = ZooKeeperUtils.getZooKeeperWorkingDir();
        boolean isSuccessful = ZooKeeperUtils.createFolder(zooKeeperWorkingDir);
        if (!isSuccessful) {
            zooKeeperWorkingDir = ZooKeeperUtils.getZooKeeperWorkingDir("zookeeper_" + System.currentTimeMillis());
            ZooKeeperUtils.createFolder(zooKeeperWorkingDir);
        }
        final String confName = zooKeeperWorkingDir + File.separator + "zoo.cfg";
        int validZkPort = ZooKeeperUtils.getValidZooKeeperPort();
        ZooKeeperUtils.prepZooKeeperConf(zooKeeperWorkingDir, confName, validZkPort + "");
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                QuorumPeerMain.main((String[])new String[]{confName});
            }
        }, "Embed ZooKeeper");
        thread.setDaemon(true);
        thread.start();
        final String cleanZkFolder = zooKeeperWorkingDir;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteDirectory(new File(cleanZkFolder));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }));
        return validZkPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String startChildZooKeeperProcess(String zkJavaOpts) throws IOException {
        String zooKeeperWorkingDir = ZooKeeperUtils.getZooKeeperWorkingDir();
        boolean isSuccessful = ZooKeeperUtils.createFolder(zooKeeperWorkingDir);
        if (!isSuccessful) {
            zooKeeperWorkingDir = ZooKeeperUtils.getZooKeeperWorkingDir("zookeeper_" + System.currentTimeMillis());
            ZooKeeperUtils.createFolder(zooKeeperWorkingDir);
        }
        String confName = zooKeeperWorkingDir + File.separator + "zoo.cfg";
        int validZkPort = ZooKeeperUtils.getValidZooKeeperPort();
        ZooKeeperUtils.prepZooKeeperConf(zooKeeperWorkingDir, confName, validZkPort + "");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<String> commandList = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            throw new IllegalArgumentException("java.home is not set!");
        }
        commandList.add(javaHome + "/bin/java");
        String[] zkJavaOptsArray = zkJavaOpts.split(" ");
        if (zkJavaOptsArray != null) {
            commandList.addAll(Arrays.asList(zkJavaOptsArray));
        }
        commandList.add("-cp");
        commandList.add(ZooKeeperUtils.findContainingJar(Log4jLoggerAdapter.class) + ":" + ZooKeeperUtils.findContainingJar(Logger.class) + ":" + ZooKeeperUtils.findContainingJar(org.apache.log4j.Logger.class) + ":" + ZooKeeperUtils.findContainingJar(ZooKeeperUtils.class) + ":" + ZooKeeperUtils.findContainingJar(QuorumPeerMain.class));
        commandList.add(ZooKeeperMain.class.getName());
        commandList.add(confName);
        processBuilder.command(commandList);
        File execDirectory = new File(zooKeeperWorkingDir);
        processBuilder.directory(execDirectory);
        processBuilder.redirectErrorStream(true);
        LOG.info("onlineZooKeeperServers: Attempting to start ZooKeeper server with command {} in directory {}.", commandList, (Object)execDirectory.toString());
        Process zkProcess = null;
        Class<ZooKeeperUtils> clazz = ZooKeeperUtils.class;
        synchronized (ZooKeeperUtils.class) {
            zkProcess = processBuilder.start();
            StreamCollector zkProcessCollector = new StreamCollector(zkProcess.getInputStream());
            zkProcessCollector.start();
            // ** MonitorExit[var12_11] (shouldn't be in output)
            Runtime.getRuntime().addShutdownHook(new Thread(new ZooKeeperShutdownHook(zkProcess, zkProcessCollector, zooKeeperWorkingDir)));
            LOG.info("onlineZooKeeperServers: Shutdown hook added.");
            String hostname = ZooKeeperUtils.getLocalHostName();
            if (ZooKeeperUtils.isServerAlive(hostname, validZkPort)) {
                return hostname + ":" + validZkPort;
            }
            return null;
        }
    }

    private static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException(e);
        }
    }

    public static String findContainingJar(Class my_class) {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static boolean checkServers(String servers) {
        String[] serverArray;
        for (String server : serverArray = servers.split(",")) {
            if (server == null) continue;
            server = server.trim();
            String port = null;
            String host = null;
            if (server.indexOf(58) > 0) {
                String[] hostAndPort = server.split(":");
                host = hostAndPort[0].trim();
                port = hostAndPort[1].trim();
            } else {
                host = server;
                port = "2181";
            }
            if (!ZooKeeperUtils.isServerAlive(host, Integer.parseInt(port))) continue;
            return true;
        }
        return false;
    }

    private static class StreamCollector
    extends Thread {
        private static final int LAST_LINES_COUNT = 100;
        private static final Logger LOG = LoggerFactory.getLogger(StreamCollector.class);
        private final BufferedReader bufferedReader;
        private final LinkedList<String> lastLines = new LinkedList();

        public StreamCollector(InputStream is) {
            super(StreamCollector.class.getName());
            this.setDaemon(true);
            InputStreamReader streamReader = new InputStreamReader(is, Charset.defaultCharset());
            this.bufferedReader = new BufferedReader(streamReader);
        }

        @Override
        public void run() {
            this.readLines();
        }

        private synchronized void readLines() {
            try {
                String line;
                while ((line = this.bufferedReader.readLine()) != null) {
                    if (this.lastLines.size() > 100) {
                        this.lastLines.removeFirst();
                    }
                    this.lastLines.add(line);
                    LOG.info("readLines: {}.", (Object)line);
                }
            }
            catch (IOException e) {
                LOG.error("readLines: Ignoring IOException", (Throwable)e);
            }
        }

        public synchronized void dumpLastLines() {
            this.readLines();
            for (String line : this.lastLines) {
                LOG.info(line);
            }
        }

        public void close() {
            try {
                this.bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ZooKeeperShutdownHook
    implements Runnable {
        private Process process;
        private StreamCollector collector;
        private String zooKeeperWorkingDir;

        public ZooKeeperShutdownHook(Process process, StreamCollector collector, String zooKeeperWorkingDir) {
            this.process = process;
            this.collector = collector;
            this.zooKeeperWorkingDir = zooKeeperWorkingDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("run: Shutdown hook started.");
            ZooKeeperShutdownHook zooKeeperShutdownHook = this;
            synchronized (zooKeeperShutdownHook) {
                if (this.process != null) {
                    LOG.warn("onlineZooKeeperServers: Forced a shutdown hook kill of the ZooKeeper process.");
                    this.process.destroy();
                    int exitCode = -1;
                    try {
                        exitCode = this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    LOG.info("onlineZooKeeperServers: ZooKeeper process exited with {} (note that 143 typically means killed).", (Object)exitCode);
                }
            }
            this.collector.close();
            FileUtils.deleteQuietly(new File(this.zooKeeperWorkingDir));
        }
    }
}

