/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.worker.WorkerContext;
import ml.shifu.guagua.worker.WorkerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcWorkerInterceptor<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
implements WorkerInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(GcWorkerInterceptor.class);
    private long appGCStartTime;
    private long iterGCStartTime;

    @Override
    public void preApplication(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.appGCStartTime = this.computeGCTime();
    }

    @Override
    public void preIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.iterGCStartTime = this.computeGCTime();
        LOG.info("Application {} container {} iteration {} starts master computation.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration()});
    }

    @Override
    public void postIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} iteration {} ends with {}ms gc time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(this.computeGCTime() - this.iterGCStartTime)});
    }

    @Override
    public void postApplication(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} ends with {}ms gc time.", new Object[]{context.getAppId(), context.getContainerId(), TimeUnit.NANOSECONDS.toMillis(this.computeGCTime() - this.appGCStartTime)});
    }

    private long computeGCTime() {
        long sum = 0L;
        List<GarbageCollectorMXBean> gcMBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollectorMXBean : gcMBeans) {
            sum += garbageCollectorMXBean.getCollectionTime();
        }
        return sum;
    }
}

