/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassUtils {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();
    private static final Map<String, Method> METHOD_CACHE = new ConcurrentHashMap<String, Method>();

    private ClassUtils() {
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            result.add(field);
        }
        Class<?> tmpClazz = clazz.getSuperclass();
        while (!Object.class.equals(tmpClazz)) {
            result.addAll(ClassUtils.getAllFields(tmpClazz));
            tmpClazz = tmpClazz.getSuperclass();
        }
        return result;
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        if (clazz == null) {
            return Collections.EMPTY_LIST;
        }
        if (clazz.equals(Object.class)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            result.add(method);
        }
        Class<?> tmpClazz = clazz.getSuperclass();
        while (!Object.class.equals(tmpClazz)) {
            result.addAll(ClassUtils.getAllMethods(tmpClazz));
            tmpClazz = tmpClazz.getSuperclass();
        }
        return result;
    }

    public static <T> T newInstance(Class<T> clazz) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(clazz);
            if (meth == null) {
                meth = clazz.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(clazz, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] parameterClasses, Object[] parameters) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(clazz);
            if (meth == null) {
                meth = clazz.getDeclaredConstructor(parameterClasses);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(clazz, meth);
            }
            result = meth.newInstance(parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static Field getDeclaredFieldIncludeSuper(String fieldName, Class<?> clazz) {
        String key = clazz.getName() + "#" + fieldName;
        Field cacheField = FIELD_CACHE.get(key);
        if (cacheField != null) {
            return cacheField;
        }
        for (Field field : ClassUtils.getAllFields(clazz)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static Method getDeclaredMethod(String methodName, Class<?> clazz) throws NoSuchMethodException {
        String key = clazz.getName() + "#" + methodName;
        Method cacheMethod = METHOD_CACHE.get(key);
        if (cacheMethod != null) {
            return cacheMethod;
        }
        return clazz.getDeclaredMethod(methodName, EMPTY_CLASS_ARRAY);
    }

    public static Method getFirstMethodWithName(String name, Class<?> clazz) {
        String key = clazz.getName() + "#" + name;
        Method cacheMethod = METHOD_CACHE.get(key);
        if (cacheMethod != null) {
            return cacheMethod;
        }
        List<Method> allMethods = ClassUtils.getAllMethods(clazz);
        Method method = null;
        for (Method f : allMethods) {
            if (!f.getName().equals(name)) continue;
            method = f;
            break;
        }
        return method;
    }

    private static void setFieldValue(Field field, Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        field.set(instance, value);
    }

    private static Object getFieldValue(Field field, Object instance) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        return field.get(instance);
    }

    public static void setFieldValue(String fieldName, Class<?> clazz, Object instance, Object value) {
        try {
            Field field = ClassUtils.getDeclaredFieldIncludeSuper(fieldName, clazz);
            ClassUtils.setFieldValue(field, instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(String fieldName, Class<?> clazz, Object instance) {
        try {
            Field field = ClassUtils.getDeclaredFieldIncludeSuper(fieldName, clazz);
            return ClassUtils.getFieldValue(field, instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            method.setAccessible(true);
            return method.invoke(instance, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeMethod(String name, Class<?> clazz, Object instance, Object ... parameters) {
        try {
            Method method = ClassUtils.getFirstMethodWithName(name, clazz);
            method.setAccessible(true);
            return method.invoke(instance, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

