/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ml.shifu.guagua.GuaguaRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressLock {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressLock.class);
    private static final int DEFAULT_MSEC_PERIOD = 10000;
    private final int msecPeriod;
    private Lock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    private boolean eventOccurred = false;

    public ProgressLock() {
        this(10000);
    }

    public ProgressLock(int msecPeriod) {
        this.msecPeriod = msecPeriod;
    }

    public void reset() {
        this.lock.lock();
        try {
            this.eventOccurred = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signal() {
        this.lock.lock();
        try {
            this.eventOccurred = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitMsecs(int msecs) {
        if (msecs < 0) {
            throw new GuaguaRuntimeException("waitMsecs: msecs cannot be negative!");
        }
        long maxMsecs = System.currentTimeMillis() + (long)msecs;
        int curMsecTimeout = 0;
        this.lock.lock();
        try {
            while (!this.eventOccurred) {
                curMsecTimeout = Math.min(msecs, this.msecPeriod);
                if (maxMsecs % 50L == 0L) {
                    LOG.info("waitMsecs: Wait for {}.", (Object)curMsecTimeout);
                }
                try {
                    boolean signaled = this.cond.await(curMsecTimeout, TimeUnit.MILLISECONDS);
                    if (maxMsecs % 50L == 0L) {
                        LOG.info("waitMsecs: Got timed signaled of {}.", (Object)signaled);
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("waitMsecs: Caught interrupted exception on cond.await() " + curMsecTimeout, e);
                }
                if (System.currentTimeMillis() > maxMsecs) {
                    boolean bl = false;
                    return bl;
                }
                msecs = Math.max(0, msecs - curMsecTimeout);
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public void waitForever() {
        while (!this.waitMsecs(this.msecPeriod)) {
        }
    }
}

