/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.util.AppendList;
import ml.shifu.guagua.util.BytableDiskList;
import ml.shifu.guagua.util.SizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytableMemoryDiskList<T extends Bytable>
implements AppendList<T> {
    private long maxByteSize = Long.MAX_VALUE;
    private long byteSize = 0L;
    private List<T> delegationList;
    private BytableDiskList<T> diskList;
    private long count;
    private long memoryCount = 0L;
    private AppendList.State state = AppendList.State.WRITE;
    private static final Logger LOG = LoggerFactory.getLogger(BytableMemoryDiskList.class);

    public BytableMemoryDiskList(long maxSize, List<T> delegationList, String className) {
        this.maxByteSize = maxSize;
        this.delegationList = delegationList;
        this.diskList = new BytableDiskList(System.currentTimeMillis() + "", className);
    }

    public BytableMemoryDiskList(List<T> delegationList, String className) {
        this.delegationList = delegationList;
        this.diskList = new BytableDiskList(System.currentTimeMillis() + "", className);
    }

    public BytableMemoryDiskList(long maxSize, List<T> delegationList, String fileName, String className) {
        this.maxByteSize = maxSize;
        this.delegationList = delegationList;
        this.diskList = new BytableDiskList(fileName, className);
    }

    public BytableMemoryDiskList(long maxSize, String fileName, String className) {
        this.maxByteSize = maxSize;
        this.delegationList = new LinkedList<T>();
        this.diskList = new BytableDiskList(fileName, className);
    }

    public BytableMemoryDiskList(long maxSize, BytableDiskList<T> bytableDiskList) {
        this.maxByteSize = maxSize;
        this.delegationList = new LinkedList<T>();
        this.diskList = bytableDiskList;
    }

    public BytableMemoryDiskList(long maxSize, String className) {
        this.maxByteSize = maxSize;
        this.delegationList = new LinkedList<T>();
        this.diskList = new BytableDiskList(System.currentTimeMillis() + "", className);
    }

    public BytableMemoryDiskList(String className) {
        this.delegationList = new LinkedList<T>();
        this.diskList = new BytableDiskList(System.currentTimeMillis() + "", className);
    }

    @Override
    public boolean append(T t) {
        try {
            if (this.state != AppendList.State.WRITE) {
                throw new IllegalStateException();
            }
            ++this.count;
            long current = SizeEstimator.estimate(t);
            if (this.byteSize + current > this.maxByteSize) {
                this.byteSize += current;
                return this.diskList.append(t);
            }
            ++this.memoryCount;
            this.byteSize += current;
            return this.delegationList.add(t);
        }
        catch (Throwable e) {
            LOG.error("append error", e);
            return false;
        }
    }

    public void close() {
        if (this.diskList != null) {
            this.diskList.close();
        }
    }

    public void reOpen() {
        this.close();
        if (this.diskList != null) {
            this.diskList.reOpen();
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.state != AppendList.State.READ) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){
            private Iterator<T> iter1;
            private Iterator<T> iter2;
            boolean isDisk;
            {
                this.iter1 = BytableMemoryDiskList.this.delegationList.iterator();
                this.iter2 = BytableMemoryDiskList.this.diskList.iterator();
                this.isDisk = false;
            }

            @Override
            public boolean hasNext() {
                if (this.iter1.hasNext()) {
                    return true;
                }
                this.isDisk = this.iter2.hasNext();
                if (!this.isDisk) {
                    BytableMemoryDiskList.this.close();
                }
                return this.isDisk;
            }

            @Override
            public T next() {
                if (!this.isDisk) {
                    return (Bytable)this.iter1.next();
                }
                return (Bytable)this.iter2.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void switchState() {
        this.state = AppendList.State.READ;
        this.diskList.switchState();
    }

    @Override
    public int size() {
        return (int)this.count;
    }

    @Override
    public void clear() {
        this.delegationList.clear();
        this.diskList.clear();
    }

    public long getMemoryCount() {
        return this.memoryCount;
    }

    public long getDiskCount() {
        return this.count - this.memoryCount;
    }
}

