/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ml.shifu.guagua.util.AppendList;
import ml.shifu.guagua.util.DiskList;
import ml.shifu.guagua.util.SizeEstimator;

public class MemoryDiskList<T extends Serializable>
implements AppendList<T> {
    private long maxByteSize = Long.MAX_VALUE;
    private long byteSize = 0L;
    private List<T> delegationList;
    private DiskList<T> diskList;
    private long count;
    private AppendList.State state = AppendList.State.WRITE;

    public MemoryDiskList(long maxSize, List<T> delegationList) {
        this.maxByteSize = maxSize;
        this.delegationList = delegationList;
        this.diskList = new DiskList(System.currentTimeMillis() + "");
    }

    public MemoryDiskList(List<T> delegationList) {
        this.delegationList = delegationList;
        this.diskList = new DiskList(System.currentTimeMillis() + "");
    }

    public MemoryDiskList(long maxSize, List<T> delegationList, String fileName) {
        this.maxByteSize = maxSize;
        this.delegationList = delegationList;
        this.diskList = new DiskList(fileName);
    }

    public MemoryDiskList(long maxSize, String fileName) {
        this.maxByteSize = maxSize;
        this.delegationList = new LinkedList<T>();
        this.diskList = new DiskList(fileName);
    }

    public MemoryDiskList(long maxSize) {
        this.maxByteSize = maxSize;
        this.delegationList = new LinkedList<T>();
        this.diskList = new DiskList(System.currentTimeMillis() + "");
    }

    public MemoryDiskList() {
        this.delegationList = new LinkedList<T>();
        this.diskList = new DiskList(System.currentTimeMillis() + "");
    }

    @Override
    public boolean append(T t) {
        if (this.state != AppendList.State.WRITE) {
            throw new IllegalStateException();
        }
        ++this.count;
        long current = SizeEstimator.estimate(t);
        if (this.byteSize + current > this.maxByteSize) {
            this.byteSize += current;
            return this.diskList.append(t);
        }
        this.byteSize += current;
        return this.delegationList.add(t);
    }

    public void close() {
        if (this.diskList != null) {
            this.diskList.close();
        }
    }

    public void reOpen() {
        this.close();
        if (this.diskList != null) {
            this.diskList.reOpen();
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.state != AppendList.State.READ) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){
            private Iterator<T> iter1;
            private Iterator<T> iter2;
            boolean isDisk;
            {
                this.iter1 = MemoryDiskList.this.delegationList.iterator();
                this.iter2 = MemoryDiskList.this.diskList.iterator();
                this.isDisk = false;
            }

            @Override
            public boolean hasNext() {
                if (this.iter1.hasNext()) {
                    return true;
                }
                this.isDisk = this.iter2.hasNext();
                if (!this.isDisk) {
                    MemoryDiskList.this.close();
                }
                return this.isDisk;
            }

            @Override
            public T next() {
                if (!this.isDisk) {
                    return (Serializable)this.iter1.next();
                }
                return (Serializable)this.iter2.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void switchState() {
        this.state = AppendList.State.READ;
        this.diskList.switchState();
    }

    @Override
    public int size() {
        return (int)this.count;
    }

    @Override
    public void clear() {
        this.delegationList.clear();
        this.diskList.clear();
    }
}

