/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.example.kmeans;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import ml.shifu.guagua.example.kmeans.KMeansMasterParams;
import ml.shifu.guagua.example.kmeans.KMeansWorkerParams;
import ml.shifu.guagua.example.kmeans.TaggedRecord;
import ml.shifu.guagua.util.MemoryDiskList;
import ml.shifu.guagua.worker.BasicWorkerInterceptor;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeansDataOutput
extends BasicWorkerInterceptor<KMeansMasterParams, KMeansWorkerParams> {
    private static final Logger LOG = LoggerFactory.getLogger(KMeansDataOutput.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postApplication(WorkerContext<KMeansMasterParams, KMeansWorkerParams> context) {
        Path outFolder = new Path(context.getProps().getProperty("kmeans.data.output", "part-g-" + context.getContainerId()));
        String separator = context.getProps().getProperty("kmeans.data.seperator");
        MemoryDiskList dataList = (MemoryDiskList)context.getAttachment();
        PrintWriter pw = null;
        try {
            FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
            fileSystem.mkdirs(outFolder);
            Path outputFile = new Path(outFolder, "part-g-" + context.getContainerId());
            FSDataOutputStream fos = fileSystem.create(outputFile);
            LOG.info("Writing results to {}", (Object)outputFile.toString());
            pw = new PrintWriter((OutputStream)fos);
            for (TaggedRecord record : dataList) {
                pw.println(record.toString(separator));
            }
            pw.flush();
            IOUtils.closeStream((Closeable)pw);
        }
        catch (IOException e) {
            LOG.error("Error in writing output.", (Throwable)e);
        }
        finally {
            IOUtils.closeStream(pw);
        }
    }
}

