/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.coordinator.zk.ZooKeeperUtils;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.worker.BasicWorkerInterceptor;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperWorkerInterceptor<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicWorkerInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperWorkerInterceptor.class);
    private static final int WAIT_SLOT_MILLS = 300;
    private long sleepTime = 300L;
    private boolean isFixedTime = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preApplication(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        String zkServers = context.getProps().getProperty("guagua.zk.servers");
        if (zkServers == null || zkServers.length() == 0 || !ZooKeeperUtils.checkServers((String)zkServers)) {
            this.sleepTime = NumberFormatUtils.getLong((String)context.getProps().getProperty("guagua.coordinator.sleep.unit"), (long)300L);
            this.isFixedTime = Boolean.TRUE.toString().equalsIgnoreCase(context.getProps().getProperty("guagua.coordinator.fixed.sleep.enable", "true"));
            String hdfsZookeeperServerFolder = this.getZookeeperServerFolder(context);
            long start = System.nanoTime();
            while (true) {
                String zookeeperServer;
                BufferedReader br;
                block9: {
                    if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) > 600000L) {
                        throw new GuaguaRuntimeException("Cannot get zookeeper server address in 10 minutes.");
                    }
                    br = null;
                    final FileSystem fileSystem = FileSystem.get((Configuration)new Configuration());
                    final Path zookeeperServerPath = fileSystem.makeQualified(new Path(hdfsZookeeperServerFolder, "zookeeper_server"));
                    LOG.info("Embeded zookeeper server address is {}", (Object)zookeeperServerPath);
                    new BasicCoordinator.RetryCoordinatorCommand(this.isFixedTime, this.sleepTime){

                        public boolean retryExecution() throws Exception, InterruptedException {
                            return fileSystem.exists(zookeeperServerPath);
                        }
                    }.execute();
                    FSDataInputStream fis = fileSystem.open(zookeeperServerPath);
                    br = new BufferedReader(new InputStreamReader((InputStream)fis));
                    zookeeperServer = br.readLine();
                    if (zookeeperServer != null && zookeeperServer.length() != 0) break block9;
                    LOG.warn("Cannot get zookeeper server in {} ", (Object)zookeeperServerPath.toString());
                    IOUtils.closeQuietly((Reader)br);
                    continue;
                }
                try {
                    LOG.info("Embeded zookeeper instance is {}", (Object)zookeeperServer);
                    context.getProps().setProperty("guagua.zk.servers", zookeeperServer);
                }
                catch (Throwable t) {
                    try {
                        LOG.warn(String.format("Error in get zookeeper address message: %s", t.getMessage()));
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.closeQuietly(br);
                        continue;
                    }
                }
                IOUtils.closeQuietly((Reader)br);
                break;
            }
        }
    }

    private String getZookeeperServerFolder(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        String defaultZooKeeperServePath = new StringBuilder(200).append("tmp").append("/").append("_guagua").append("/").append(context.getAppId()).append("/").toString();
        String hdfsZookeeperServerPath = context.getProps().getProperty("guagua.zk.cluster.server.folder", defaultZooKeeperServePath);
        return hdfsZookeeperServerPath;
    }
}

