/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaInputSplit
extends InputSplit
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaInputSplit.class);
    private boolean isMaster;
    private FileSplit[] fileSplits;
    private Object[] extensions;

    public GuaguaInputSplit() {
    }

    public GuaguaInputSplit(boolean isMaster, FileSplit ... fileSplits) {
        this.isMaster = isMaster;
        this.fileSplits = fileSplits;
    }

    public GuaguaInputSplit(boolean isMaster, FileSplit fileSplit) {
        this(isMaster, new FileSplit[]{fileSplit});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isMaster());
        if (!this.isMaster()) {
            int i;
            int length = this.getFileSplits().length;
            out.writeInt(length);
            for (i = 0; i < length; ++i) {
                this.getFileSplits()[i].write(out);
            }
            if (this.extensions != null) {
                out.writeInt(this.extensions.length);
                for (i = 0; i < this.extensions.length; ++i) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream ext = null;
                    try {
                        ext = new ObjectOutputStream(bos);
                        ext.writeObject(this.extensions[i]);
                        byte[] bytes = bos.toByteArray();
                        out.writeInt(bytes.length);
                        out.write(bytes);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)bos);
                    }
                }
            } else {
                out.writeInt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFields(DataInput in) throws IOException {
        this.setMaster(in.readBoolean());
        if (!this.isMaster()) {
            int len = in.readInt();
            FileSplit[] splits = new FileSplit[len];
            for (int i = 0; i < len; ++i) {
                splits[i] = new FileSplit(null, 0L, 0L, (String[])null);
                splits[i].readFields(in);
            }
            this.setFileSplits(splits);
            int extLen = in.readInt();
            if (extLen > 0) {
                Object[] exts = new Object[extLen];
                for (int i = 0; i < extLen; ++i) {
                    int objectLen = in.readInt();
                    byte[] bytes = new byte[objectLen];
                    in.readFully(bytes);
                    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                    ObjectInputStream ext = new ObjectInputStream(bis);
                    try {
                        Object extension;
                        exts[i] = extension = ext.readObject();
                        continue;
                    }
                    catch (ClassNotFoundException ce) {
                        LOG.error(ce.getMessage(), (Throwable)ce);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)bis);
                    }
                }
                this.setExtensions(exts);
            }
        }
    }

    public long getLength() throws IOException, InterruptedException {
        if (this.isMaster()) {
            return Long.MAX_VALUE;
        }
        long len = 0L;
        for (FileSplit split : this.getFileSplits()) {
            len += split.getLength();
        }
        return len;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.getFileSplits() == null || this.getFileSplits().length == 0) {
            return new String[0];
        }
        ArrayList<String> hosts = new ArrayList<String>();
        for (FileSplit fileSplit : this.getFileSplits()) {
            if (fileSplit == null) continue;
            hosts.addAll(Arrays.asList(fileSplit.getLocations()));
        }
        return hosts.toArray(new String[0]);
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public FileSplit[] getFileSplits() {
        return this.fileSplits;
    }

    public void setFileSplits(FileSplit[] fileSplits) {
        this.fileSplits = fileSplits;
    }

    public Object[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Object[] extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        return String.format("GuaguaInputSplit [isMaster=%s, fileSplit=%s]", this.isMaster, Arrays.toString(this.fileSplits));
    }
}

