/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.master.BasicMasterInterceptor;
import ml.shifu.guagua.master.MasterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterComputableTimer<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicMasterInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(MasterComputableTimer.class);
    private long applicationStartTime;
    private long iterationStartTime;

    @Override
    public void preApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.applicationStartTime = System.nanoTime();
        LOG.info("Application {} container {} computation starts internal master computation.", (Object)context.getAppId(), (Object)context.getContainerId());
    }

    @Override
    public void preIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.iterationStartTime = System.nanoTime();
        LOG.info("Application {} container {} iteration {} computation starts internal master computatio.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration()});
    }

    @Override
    public void postIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} iteration {} computation ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.iterationStartTime)});
    }

    @Override
    public void postApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} computation ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.applicationStartTime)});
    }
}

