/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.master.MasterInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterTimer<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
implements MasterInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(MasterTimer.class);
    private long applicationStartTime;
    private long iterationStartTime;

    @Override
    public void preApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.applicationStartTime = System.nanoTime();
        LOG.info("Application {} container {} starts master computation.", (Object)context.getAppId(), (Object)context.getContainerId());
    }

    @Override
    public void preIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.iterationStartTime = System.nanoTime();
        LOG.info("Application {} container {} iteration {} starts master computation.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration()});
    }

    @Override
    public void postIteration(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} iteration {} ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.iterationStartTime)});
    }

    @Override
    public void postApplication(MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.applicationStartTime)});
    }
}

