/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import ml.shifu.guagua.MemoryCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.worker.BasicWorkerInterceptor;
import ml.shifu.guagua.worker.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalWorkerCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicWorkerInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(InternalWorkerCoordinator.class);
    private MemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator;

    @Override
    public void preApplication(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.coordinator.signalMaster(context.getCurrentIteration(), Integer.parseInt(context.getContainerId()) - 1, null);
        LOG.info("Worker {} is initilized.", (Object)context.getContainerId());
        this.coordinator.awaitMaster(context.getCurrentIteration());
    }

    @Override
    public void preIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        context.setLastMasterResult(this.coordinator.getMasterResult());
        LOG.info("Worker {} is started in iteration {}.", (Object)context.getContainerId(), (Object)context.getCurrentIteration());
    }

    @Override
    public void postIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.coordinator.signalMaster(context.getCurrentIteration(), Integer.parseInt(context.getContainerId()) - 1, context.getWorkerResult());
        this.coordinator.awaitMaster(context.getCurrentIteration());
        LOG.info("Worker {} is done in iteration {}.", (Object)context.getContainerId(), (Object)context.getCurrentIteration());
    }

    public void setCoordinator(MemoryCoordinator<MASTER_RESULT, WORKER_RESULT> coordinator) {
        this.coordinator = coordinator;
    }
}

