/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.util.StringUtils;
import ml.shifu.guagua.worker.WorkerContext;
import ml.shifu.guagua.worker.WorkerInterceptor;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkerCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicCoordinator<MASTER_RESULT, WORKER_RESULT>
implements WorkerInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWorkerCoordinator.class);

    @Override
    public void preIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Start itertion {} with container id {} and app id {}.", new Object[]{context.getCurrentIteration(), context.getContainerId(), context.getAppId()});
    }

    @Override
    public void postApplication(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                block5: {
                    try {
                        int currentIteration;
                        String containerId;
                        String appId;
                        block6: {
                            String zkCleanUpEnabled = StringUtils.get(context.getProps().getProperty("guagua.zk.cleanup.enable"), "true");
                            if (!Boolean.TRUE.toString().equalsIgnoreCase(zkCleanUpEnabled)) break block5;
                            appId = context.getAppId();
                            containerId = context.getContainerId();
                            currentIteration = context.getCurrentIteration();
                            String currentWorkerNode = AbstractWorkerCoordinator.this.getCurrentWorkerNode(appId, containerId, currentIteration - 1).toString();
                            try {
                                AbstractWorkerCoordinator.this.getZooKeeper().deleteExt(currentWorkerNode, -1, false);
                            }
                            catch (KeeperException.NoNodeException e) {
                                if (System.nanoTime() % 20L != 0L) break block6;
                                LOG.warn("No such node:{}", (Object)currentWorkerNode);
                            }
                        }
                        String appWorkerNode = AbstractWorkerCoordinator.this.getCurrentWorkerNode(appId, containerId, currentIteration).toString();
                        AbstractWorkerCoordinator.this.getZooKeeper().createExt(appWorkerNode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    }
                    finally {
                        AbstractWorkerCoordinator.this.closeZooKeeper();
                    }
                }
            }
        }.execute();
    }

    protected void setMasterResult(WorkerContext<MASTER_RESULT, WORKER_RESULT> context, String appMasterNode, String appMasterSplitNode) throws KeeperException, InterruptedException {
        if (context.getCurrentIteration() == 0) {
            return;
        }
        byte[] data = this.getBytesFromZNode(appMasterNode, appMasterSplitNode);
        if (data != null && data.length > 0) {
            Object lastMasterResult = this.getMasterSerializer().bytesToObject(data, context.getMasterResultClassName());
            context.setLastMasterResult(lastMasterResult);
        }
    }

    protected class FailOverCoordinatorCommand
    extends BasicCoordinator.BasicCoordinatorCommand {
        private final WorkerContext<MASTER_RESULT, WORKER_RESULT> context;

        public FailOverCoordinatorCommand(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
            this.context = context;
        }

        @Override
        public void doExecute() throws KeeperException, InterruptedException {
            String masterBaseNode = AbstractWorkerCoordinator.this.getMasterBaseNode(this.context.getAppId()).toString();
            List<String> masterIterations = null;
            try {
                masterIterations = AbstractWorkerCoordinator.this.getZooKeeper().getChildrenExt(masterBaseNode, false, false, false);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.warn("No such node:{}", (Object)masterBaseNode);
            }
            if (masterIterations != null && masterIterations.size() > 0) {
                Collections.sort(masterIterations, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
                    }
                });
                LOG.info("DEBUG: master children:{}", masterIterations);
                try {
                    int restartedIteration = Integer.valueOf(masterIterations.get(masterIterations.size() - 1));
                    this.context.setCurrentIteration(restartedIteration);
                    LOG.info("Container {} restarted at: {} step.", (Object)this.context.getContainerId(), (Object)restartedIteration);
                }
                catch (NumberFormatException e) {
                    this.context.setCurrentIteration(0);
                }
            }
        }
    }
}

