/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.filter;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.csv.filter.ExcludedField;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class FilterCSV
extends BasicFile {
    private final List<ExcludedField> excludedFields = new ArrayList<ExcludedField>();
    private int filteredCount;

    public final void analyze(File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.setAnalyzed(true);
        this.performBasicCounts();
    }

    public final void exclude(int fieldNumber, String fieldValue) {
        this.excludedFields.add(new ExcludedField(fieldNumber, fieldValue));
    }

    public final List<ExcludedField> getExcluded() {
        return this.excludedFields;
    }

    public final int getFilteredRowCount() {
        return this.filteredCount;
    }

    public final void process(File outputFile) {
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getInputFormat());
        PrintWriter tw = this.prepareOutputFile(outputFile);
        this.filteredCount = 0;
        this.resetStatus();
        while (csv.next() && !this.shouldStop()) {
            this.updateStatus(false);
            LoadedRow row = new LoadedRow(csv);
            if (!this.shouldProcess(row)) continue;
            this.writeRow(tw, row);
            ++this.filteredCount;
        }
        this.reportDone(false);
        tw.close();
        csv.close();
    }

    private boolean shouldProcess(LoadedRow row) {
        for (ExcludedField field : this.excludedFields) {
            if (!row.getData()[field.getFieldNumber()].trim().equals(field.getFieldValue().trim())) continue;
            return false;
        }
        return true;
    }
}

