/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class GuaguaInputSplit
extends InputSplit
implements Writable {
    private boolean isMaster;
    private FileSplit[] fileSplits;

    public GuaguaInputSplit() {
    }

    public GuaguaInputSplit(boolean isMaster, FileSplit ... fileSplits) {
        this.isMaster = isMaster;
        this.fileSplits = fileSplits;
    }

    public GuaguaInputSplit(boolean isMaster, FileSplit fileSplit) {
        this(isMaster, new FileSplit[]{fileSplit});
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isMaster());
        if (!this.isMaster()) {
            int length = this.getFileSplits().length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.getFileSplits()[i].write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.setMaster(in.readBoolean());
        if (!this.isMaster()) {
            int len = in.readInt();
            FileSplit[] splits = new FileSplit[len];
            for (int i = 0; i < len; ++i) {
                splits[i] = new FileSplit(null, 0L, 0L, (String[])null);
                splits[i].readFields(in);
            }
            this.setFileSplits(splits);
        }
    }

    public long getLength() throws IOException, InterruptedException {
        if (this.isMaster()) {
            return Long.MAX_VALUE;
        }
        long len = 0L;
        for (FileSplit split : this.getFileSplits()) {
            len += split.getLength();
        }
        return len;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public FileSplit[] getFileSplits() {
        return this.fileSplits;
    }

    public void setFileSplits(FileSplit[] fileSplits) {
        this.fileSplits = fileSplits;
    }

    public String toString() {
        return String.format("GuaguaInputSplit [isMaster=%s, fileSplits=%s]", this.isMaster, Arrays.toString(this.fileSplits));
    }
}

