/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.master;

import java.util.List;
import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.master.AbstractMasterCoordinator;
import ml.shifu.guagua.master.MasterContext;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.ProgressLock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMasterCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends AbstractMasterCoordinator<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncMasterCoordinator.class);
    private int currentIteration;
    private String appId;
    protected ProgressLock workerInitLock = new ProgressLock();
    protected ProgressLock workerIterationLock = new ProgressLock();

    @Override
    public void process(WatchedEvent event) {
        LOG.debug("DEBUG: process: Got a new event, path = {}, type = {}, state = {}", new Object[]{event.getPath(), event.getType(), event.getState()});
        if (event.getPath() == null && event.getType() == Watcher.Event.EventType.None) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                LOG.info("process: Asynchronous connection complete.");
                super.getZkConnLatch().countDown();
            } else {
                LOG.warn("process: Got unknown null path event " + event);
            }
            return;
        }
        String appWorkerBaseNode = this.getWorkerBaseNode(this.getAppId(), this.getCurrentIteration()).toString();
        if (event.getPath().equals(appWorkerBaseNode) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (this.getCurrentIteration() == 0) {
                this.workerInitLock.signal();
            } else {
                this.workerIterationLock.signal();
            }
        }
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        this.currentIteration = currentIteration;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public void preApplication(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.initialize(context.getProps());
        this.setAppId(context.getAppId());
        if (NumberFormatUtils.getInt(context.getProps().getProperty("guagua.master.number"), 1) > 1) {
            new AbstractMasterCoordinator.MasterElectionCommand(context.getAppId()).execute();
        }
        new AbstractMasterCoordinator.FailOverCommand(context).execute();
        if (context.getCurrentIteration() != 0) {
            return;
        }
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                final String appWorkersNode = AsyncMasterCoordinator.this.getWorkerBaseNode(context.getAppId(), context.getCurrentIteration()).toString();
                new BasicCoordinator.RetryCoordinatorCommand(AsyncMasterCoordinator.this.isFixedTime(), AsyncMasterCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        block5: {
                            try {
                                int size;
                                List<String> children = AsyncMasterCoordinator.this.getZooKeeper().getChildrenExt(appWorkersNode, false, false, false);
                                int n = size = children == null ? 0 : children.size();
                                if (this.isTerminated(size, context.getWorkers(), context.getMinWorkersRatio(), context.getMinWorkersTimeOut())) {
                                    return true;
                                }
                                children = AsyncMasterCoordinator.this.getZooKeeper().getChildrenExt(appWorkersNode, true, false, false);
                                int n2 = size = children == null ? 0 : children.size();
                                if (this.isTerminated(size, context.getWorkers(), context.getMinWorkersRatio(), context.getMinWorkersTimeOut())) {
                                    return true;
                                }
                                if (System.nanoTime() % 20L == 0L) {
                                    LOG.info("workers already initialized: {}, still {} workers are not synced.", (Object)size, (Object)(context.getWorkers() - size));
                                }
                                AsyncMasterCoordinator.this.workerInitLock.waitForever();
                                AsyncMasterCoordinator.this.workerInitLock.reset();
                            }
                            catch (KeeperException.NoNodeException e) {
                                if (System.nanoTime() % 10L != 0L) break block5;
                                LOG.warn("No such node:{}", (Object)appWorkersNode);
                            }
                        }
                        return false;
                    }
                }.execute();
                LOG.info("All workers are initiliazed successfully.");
                String znode = null;
                try {
                    znode = AsyncMasterCoordinator.this.getWorkerBaseNode(context.getAppId(), context.getCurrentIteration() + 1).toString();
                    AsyncMasterCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    znode = AsyncMasterCoordinator.this.getMasterBaseNode(context.getAppId()).toString();
                    AsyncMasterCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                    znode = AsyncMasterCoordinator.this.getCurrentMasterNode(context.getAppId(), context.getCurrentIteration()).toString();
                    AsyncMasterCoordinator.this.getZooKeeper().createExt(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.warn("Node exists: {}", znode);
                }
            }
        }.execute();
    }

    @Override
    public void preIteration(final MasterContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.setCurrentIteration(context.getCurrentIteration());
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                final int currentIteration = context.getCurrentIteration();
                final int workers = context.getWorkers();
                final String appCurrentWorkersNode = AsyncMasterCoordinator.this.getWorkerBaseNode(context.getAppId(), currentIteration).toString();
                long start = System.nanoTime();
                new BasicCoordinator.RetryCoordinatorCommand(AsyncMasterCoordinator.this.isFixedTime(), AsyncMasterCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        block5: {
                            try {
                                int size;
                                List<String> workerChildern = AsyncMasterCoordinator.this.getZooKeeper().getChildrenExt(appCurrentWorkersNode, false, false, false);
                                int n = size = workerChildern == null ? 0 : workerChildern.size();
                                if (this.isTerminated(size, context.getWorkers(), context.getMinWorkersRatio(), context.getMinWorkersTimeOut())) {
                                    return true;
                                }
                                workerChildern = AsyncMasterCoordinator.this.getZooKeeper().getChildrenExt(appCurrentWorkersNode, true, false, false);
                                int n2 = size = workerChildern == null ? 0 : workerChildern.size();
                                if (this.isTerminated(size, context.getWorkers(), context.getMinWorkersRatio(), context.getMinWorkersTimeOut())) {
                                    return true;
                                }
                                if (System.nanoTime() % 20L == 0L) {
                                    LOG.info("iteration {}, workers compelted: {}, still {} workers are not synced.", new Object[]{currentIteration, size, workers - size});
                                }
                                AsyncMasterCoordinator.this.workerIterationLock.waitForever();
                                AsyncMasterCoordinator.this.workerIterationLock.reset();
                            }
                            catch (KeeperException.NoNodeException e) {
                                if (System.nanoTime() % 10L != 0L) break block5;
                                LOG.warn("No such node:{}", (Object)appCurrentWorkersNode);
                            }
                        }
                        return false;
                    }
                }.execute();
                LOG.info("Application {} container {} iteration {} waiting ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
                AsyncMasterCoordinator.this.setWorkerResults(context, appCurrentWorkersNode, context.getAppId(), currentIteration);
            }
        }.execute();
    }
}

