/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.util.AppendList;
import ml.shifu.guagua.util.FileUtils;
import ml.shifu.guagua.util.JavaObjectSerializer;
import ml.shifu.guagua.util.ObjectSerializer;

public class DiskList<T extends Serializable>
implements AppendList<T> {
    private ObjectSerializer<T> serializer = new JavaObjectSerializer();
    private OutputStream outputStream;
    private InputStream inputStream;
    private AppendList.State state = AppendList.State.WRITE;
    private File file;
    private long count;

    public DiskList(String fileName) {
        try {
            this.file = new File(fileName);
            this.outputStream = new FileOutputStream(this.file);
            this.inputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
    }

    @Override
    public void switchState() {
        this.state = AppendList.State.READ;
    }

    public void reOpen() {
        this.close();
        try {
            this.inputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new GuaguaRuntimeException(e);
        }
    }

    @Override
    public boolean append(T t) {
        if (this.state != AppendList.State.WRITE) {
            throw new IllegalStateException();
        }
        ++this.count;
        byte[] bytes = this.getSerializer().serialize(t);
        try {
            this.outputStream.write(bytes.length);
            this.outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new GuaguaRuntimeException(e);
        }
        return true;
    }

    public void close() {
        try {
            this.outputStream.close();
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.state != AppendList.State.READ) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return DiskList.this.inputStream.available() > 0;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public T next() {
                try {
                    int length = DiskList.this.inputStream.read();
                    byte[] bytes = new byte[length];
                    int size = DiskList.this.inputStream.read(bytes);
                    if (size < 0) {
                        throw new GuaguaRuntimeException("IO exception on reading disk file.");
                    }
                    return (Serializable)DiskList.this.getSerializer().deserialize(bytes, null);
                }
                catch (IOException e) {
                    throw new GuaguaRuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ObjectSerializer<T> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ObjectSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public void clear() {
        FileUtils.deleteQuietly(this.file);
    }
}

