/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation;

import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.error.ErrorFunction;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.flat.train.TrainFlatNetwork;
import org.encog.neural.flat.train.prop.TrainFlatNetworkProp;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.Train;
import org.encog.util.EncogValidate;
import org.encog.util.concurrency.MultiThreadable;
import org.encog.util.logging.EncogLogging;

public abstract class Propagation
extends BasicTraining
implements Train,
MultiThreadable {
    private final ContainsFlat network;
    private FlatNetwork currentFlatNetwork;
    private TrainFlatNetwork flatTraining;

    public Propagation(ContainsFlat network, MLDataSet training) {
        super(TrainingImplementationType.Iterative);
        this.network = network;
        this.setTraining(training);
    }

    @Override
    public final void finishTraining() {
        super.finishTraining();
        this.flatTraining.finishTraining();
    }

    public final FlatNetwork getCurrentFlatNetwork() {
        return this.currentFlatNetwork;
    }

    public final TrainFlatNetwork getFlatTraining() {
        return this.flatTraining;
    }

    @Override
    public final MLMethod getMethod() {
        return this.network;
    }

    @Override
    public final int getThreadCount() {
        return this.flatTraining.getNumThreads();
    }

    @Override
    public final void iteration() {
        try {
            this.preIteration();
            this.flatTraining.iteration();
            this.setError(this.flatTraining.getError());
            this.postIteration();
            EncogLogging.log(1, "Training iteration done, error: " + this.getError());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            EncogValidate.validateNetworkForTraining(this.network, this.getTraining());
            throw new EncogError(ex);
        }
    }

    @Override
    public final void iteration(int count) {
        try {
            this.preIteration();
            this.flatTraining.iteration(count);
            this.setIteration(this.flatTraining.getIteration());
            this.setError(this.flatTraining.getError());
            this.postIteration();
            EncogLogging.log(1, "Training iterations done, error: " + this.getError());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            EncogValidate.validateNetworkForTraining(this.network, this.getTraining());
            throw new EncogError(ex);
        }
    }

    public final void setFlatTraining(TrainFlatNetwork flatTraining) {
        this.flatTraining = flatTraining;
    }

    @Override
    public final void setThreadCount(int numThreads) {
        this.flatTraining.setNumThreads(numThreads);
    }

    public void fixFlatSpot(boolean b) {
        ((TrainFlatNetworkProp)this.flatTraining).fixFlatSpot(b);
    }

    public void setErrorFunction(ErrorFunction ef) {
        ((TrainFlatNetworkProp)this.flatTraining).setErrorFunction(ef);
    }
}

