/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.encog.neural.thermal.BoltzmannMachine;

public class BoltzmannPattern
implements NeuralNetworkPattern {
    private int neuronCount;
    private int annealCycles = 100;
    private int runCycles = 1000;
    private double temperature = 0.0;

    @Override
    public final void addHiddenLayer(int count) {
        throw new PatternError("A Boltzmann network has no hidden layers.");
    }

    @Override
    public final void clear() {
        this.neuronCount = 0;
    }

    @Override
    public final MLMethod generate() {
        BoltzmannMachine boltz = new BoltzmannMachine(this.neuronCount);
        boltz.setTemperature(this.temperature);
        boltz.setRunCycles(this.runCycles);
        boltz.setAnnealCycles(this.annealCycles);
        return boltz;
    }

    public final int getAnnealCycles() {
        return this.annealCycles;
    }

    public final int getRunCycles() {
        return this.runCycles;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    @Override
    public final void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("A Boltzmann network will use the BiPolar activation function, no activation function needs to be specified.");
    }

    public final void setAnnealCycles(int annealCycles) {
        this.annealCycles = annealCycles;
    }

    @Override
    public final void setInputNeurons(int count) {
        this.neuronCount = count;
    }

    @Override
    public final void setOutputNeurons(int count) {
        this.neuronCount = count;
    }

    public final void setRunCycles(int runCycles) {
        this.runCycles = runCycles;
    }

    public final void setTemperature(double temperature) {
        this.temperature = temperature;
    }
}

