/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.coordinator.zk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ml.shifu.guagua.coordinator.zk.GuaguaZooKeeperOperation;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaguaZooKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(GuaguaZooKeeper.class);
    private static final int SEQUENCE_NUMBER_LENGTH = 10;
    private final ZooKeeper zooKeeper;
    private final int maxRetryAttempts;
    private final long retryWaitMsecs;
    private static final SequenceComparator sequenceComparator = new SequenceComparator();

    public GuaguaZooKeeper(String connectString, int sessionTimeout, int maxRetryAttempts, int retryWaitMsecs, Watcher watcher) throws IOException {
        if (maxRetryAttempts <= 0) {
            throw new IllegalArgumentException("'maxRetryAttempts' should be larger than 0.");
        }
        if (retryWaitMsecs <= 0) {
            throw new IllegalArgumentException("'retryWaitMsecs' should be larger than 0.");
        }
        this.zooKeeper = new ZooKeeper(connectString, sessionTimeout, watcher);
        this.maxRetryAttempts = maxRetryAttempts;
        this.retryWaitMsecs = retryWaitMsecs;
    }

    public String createExt(final String path, final byte[] data, final List<ACL> acl, final CreateMode createMode, final boolean recursive) throws KeeperException, InterruptedException {
        String result = this.retryOperation(new GuaguaZooKeeperOperation<String>(){

            @Override
            public String execute() throws KeeperException, InterruptedException {
                if (!recursive) {
                    return GuaguaZooKeeper.this.getZooKeeper().create(path, data, acl, createMode);
                }
                try {
                    return GuaguaZooKeeper.this.getZooKeeper().create(path, data, acl, createMode);
                }
                catch (KeeperException.NoNodeException e) {
                    LOG.warn("createExt: Cannot directly create node {} because of NoNodeException.", (Object)path);
                    int pos = path.indexOf("/", 1);
                    while (pos != -1) {
                        String subPath = path.substring(0, pos);
                        try {
                            GuaguaZooKeeper.this.getZooKeeper().create(subPath, null, acl, CreateMode.PERSISTENT);
                        }
                        catch (KeeperException.NodeExistsException e2) {
                            LOG.warn("createExt: Znode {} already exists", (Object)subPath);
                        }
                        pos = path.indexOf("/", pos + 1);
                    }
                    return GuaguaZooKeeper.this.getZooKeeper().create(path, data, acl, createMode);
                }
            }
        });
        return result;
    }

    public PathStat createOrSetExt(String path, byte[] data, List<ACL> acl, CreateMode createMode, boolean recursive, int version) throws KeeperException, InterruptedException {
        String createdPath = null;
        Stat setStat = null;
        try {
            createdPath = this.createExt(path, data, acl, createMode, recursive);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn("createOrSet: Node exists on path {}", (Object)path);
            setStat = this.getZooKeeper().setData(path, data, version);
        }
        return new PathStat(createdPath, setStat);
    }

    public PathStat createOnceExt(String path, byte[] data, List<ACL> acl, CreateMode createMode, boolean recursive) throws KeeperException, InterruptedException {
        try {
            return new PathStat(this.createExt(path, data, acl, createMode, recursive), null);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.warn("createOnceExt: Node already exists on path {}", (Object)path);
            return null;
        }
    }

    public void deleteExt(final String path, final int version, final boolean recursive) throws InterruptedException, KeeperException {
        this.retryOperation(new GuaguaZooKeeperOperation<Void>(){

            @Override
            public Void execute() throws KeeperException, InterruptedException {
                if (!recursive) {
                    GuaguaZooKeeper.this.getZooKeeper().delete(path, version);
                    return null;
                }
                try {
                    GuaguaZooKeeper.this.getZooKeeper().delete(path, version);
                    return null;
                }
                catch (KeeperException.NotEmptyException e) {
                    LOG.warn("deleteExt: Cannot directly remove node {}", (Object)path);
                    List childList = GuaguaZooKeeper.this.getZooKeeper().getChildren(path, false);
                    for (String child : childList) {
                        GuaguaZooKeeper.this.deleteExt(path + "/" + child, -1, true);
                    }
                    GuaguaZooKeeper.this.getZooKeeper().delete(path, version);
                    return null;
                }
            }
        });
    }

    public Stat exists(final String path, final boolean watch) throws KeeperException, InterruptedException {
        return this.retryOperation(new GuaguaZooKeeperOperation<Stat>(){

            @Override
            public Stat execute() throws KeeperException, InterruptedException {
                return GuaguaZooKeeper.this.getZooKeeper().exists(path, watch);
            }
        });
    }

    public Stat exists(final String path, final Watcher watcher) throws KeeperException, InterruptedException {
        return this.retryOperation(new GuaguaZooKeeperOperation<Stat>(){

            @Override
            public Stat execute() throws KeeperException, InterruptedException {
                return GuaguaZooKeeper.this.getZooKeeper().exists(path, watcher);
            }
        });
    }

    public byte[] getData(final String path, final Watcher watcher, final Stat stat) throws KeeperException, InterruptedException {
        return this.retryOperation(new GuaguaZooKeeperOperation<byte[]>(){

            @Override
            public byte[] execute() throws KeeperException, InterruptedException {
                return GuaguaZooKeeper.this.getZooKeeper().getData(path, watcher, stat);
            }
        });
    }

    public byte[] getData(final String path, final boolean watch, final Stat stat) throws KeeperException, InterruptedException {
        return this.retryOperation(new GuaguaZooKeeperOperation<byte[]>(){

            @Override
            public byte[] execute() throws KeeperException, InterruptedException {
                return GuaguaZooKeeper.this.getZooKeeper().getData(path, watch, stat);
            }
        });
    }

    public List<String> getChildrenExt(final String path, final boolean watch, final boolean fullPath, final Comparator<String> childComparator) throws KeeperException, InterruptedException {
        return this.retryOperation(new GuaguaZooKeeperOperation<List<String>>(){

            @Override
            public List<String> execute() throws KeeperException, InterruptedException {
                List childList = GuaguaZooKeeper.this.getZooKeeper().getChildren(path, watch);
                if (childComparator != null) {
                    Collections.sort(childList, childComparator);
                }
                if (fullPath) {
                    ArrayList<String> fullChildList = new ArrayList<String>();
                    for (String child : childList) {
                        fullChildList.add(path + "/" + child);
                    }
                    return fullChildList;
                }
                return childList;
            }
        });
    }

    public List<String> getChildrenExt(final String path, final boolean watch, final boolean sequenceSorted, final boolean fullPath) throws KeeperException, InterruptedException {
        return this.retryOperation(new GuaguaZooKeeperOperation<List<String>>(){

            @Override
            public List<String> execute() throws KeeperException, InterruptedException {
                List childList = GuaguaZooKeeper.this.getZooKeeper().getChildren(path, watch);
                if (sequenceSorted) {
                    Collections.sort(childList, sequenceComparator);
                }
                if (fullPath) {
                    ArrayList<String> fullChildList = new ArrayList<String>();
                    for (String child : childList) {
                        fullChildList.add(path + "/" + child);
                    }
                    return fullChildList;
                }
                return childList;
            }
        });
    }

    public List<String> getChildrenExt(final String path, final boolean watch, final boolean sequenceSorted, final boolean fullPath, final Filter filter) throws KeeperException, InterruptedException {
        return this.retryOperation(new GuaguaZooKeeperOperation<List<String>>(){

            @Override
            public List<String> execute() throws KeeperException, InterruptedException {
                List childList = GuaguaZooKeeper.this.getZooKeeper().getChildren(path, watch);
                if (sequenceSorted) {
                    Collections.sort(childList, sequenceComparator);
                }
                ArrayList<String> result = new ArrayList<String>();
                for (String child : childList) {
                    String realPath;
                    String string = realPath = fullPath ? path + "/" + child : child;
                    if (filter != null && filter.filter(realPath)) continue;
                    result.add(realPath);
                }
                return result;
            }
        });
    }

    public void close() throws InterruptedException {
        this.getZooKeeper().close();
    }

    protected <T> T retryOperation(GuaguaZooKeeperOperation<T> operation) throws KeeperException, InterruptedException {
        KeeperException.ConnectionLossException exception = null;
        for (int i = 0; i < this.getMaxRetryAttempts(); ++i) {
            try {
                return operation.execute();
            }
            catch (KeeperException.SessionExpiredException e) {
                LOG.warn("Session expired so reconnecting due to:", (Throwable)e);
                throw e;
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                LOG.debug("Attempt {} failed with connection loss so attempting to reconnect. Exception is: {} ", (Object)i, (Object)e);
                this.retryDelay(i);
                continue;
            }
        }
        throw exception;
    }

    protected void retryDelay(int attemptCount) {
        if (attemptCount > 0) {
            try {
                Thread.sleep((long)attemptCount * this.getRetryWaitMsecs());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public int getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public long getRetryWaitMsecs() {
        return this.retryWaitMsecs;
    }

    public static interface Filter {
        public boolean filter(String var1);
    }

    private static class SequenceComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 4555088814306270860L;

        private SequenceComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.length() <= 10 || s2.length() <= 10) {
                throw new RuntimeException(String.format("getChildrenExt: Invalid length for sequence  sorting > %s for s1 (%s) or s2 (%s)", 10, s1.length(), s2.length()));
            }
            Integer s1SequenceNumber = Integer.parseInt(s1.substring(s1.length() - 10));
            Integer s2SequenceNumber = Integer.parseInt(s2.substring(s2.length() - 10));
            return s1SequenceNumber.compareTo(s2SequenceNumber);
        }
    }

    public static class PathStat {
        private String path;
        private Stat stat;

        public PathStat(String path, Stat stat) {
            this.path = path;
            this.stat = stat;
        }

        public String getPath() {
            return this.path;
        }

        public Stat getStat() {
            return this.stat;
        }
    }
}

