/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.BytableWrapper;
import ml.shifu.guagua.io.NettyBytableDecoder;
import ml.shifu.guagua.io.NettyBytableEncoder;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.worker.AbstractWorkerCoordinator;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.zookeeper.KeeperException;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWorkerCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends AbstractWorkerCoordinator<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyWorkerCoordinator.class);
    private String masterServerAddress;
    private ClientBootstrap messageClient;
    private Channel clientChannel;
    private AtomicBoolean isServerShutdown = new AtomicBoolean(false);

    @Override
    public void preApplication(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.initialize(context.getProps());
        new AbstractWorkerCoordinator.FailOverCoordinatorCommand(context).execute();
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appId = context.getAppId();
                final String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, 0).toString();
                new BasicCoordinator.RetryCoordinatorCommand(NettyWorkerCoordinator.this.isFixedTime(), NettyWorkerCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        try {
                            return NettyWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, false) != null;
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 10L == 0L) {
                                LOG.warn("No such node:{}", (Object)appMasterNode);
                            }
                            return false;
                        }
                    }
                }.execute();
                NettyWorkerCoordinator.this.masterServerAddress = new String(NettyWorkerCoordinator.this.getBytesFromZNode(appMasterNode, null), Charset.forName("UTF-8"));
            }
        }.execute();
        this.connectMasterServer();
        if (!context.isInitIteration()) {
            new BasicCoordinator.BasicCoordinatorCommand(){

                @Override
                public void doExecute() throws KeeperException, InterruptedException {
                    String appId = context.getAppId();
                    int currentIteration = context.getCurrentIteration();
                    String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                    String appMasterSplitNode = NettyWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                    NettyWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                }
            }.execute();
        }
    }

    private void connectMasterServer() {
        this.messageClient = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newSingleThreadExecutor(), (Executor)Executors.newSingleThreadExecutor()));
        this.messageClient.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new NettyBytableEncoder(), new NettyBytableDecoder(), new ClientHandler()});
            }
        });
        String[] namePortGroup = this.masterServerAddress.split(":");
        String masterServerName = namePortGroup[0];
        int masterServerPort = NumberFormatUtils.getInt(namePortGroup[1]);
        ChannelFuture future = this.messageClient.connect((SocketAddress)new InetSocketAddress(masterServerName, masterServerPort));
        this.clientChannel = future.awaitUninterruptibly().getChannel();
        LOG.info("Connect to {}:{}", (Object)masterServerName, (Object)masterServerPort);
    }

    @Override
    public void preIteration(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        if (this.isServerShutdown.get()) {
            new AbstractWorkerCoordinator.FailOverCoordinatorCommand(context).execute();
            new BasicCoordinator.BasicCoordinatorCommand(){

                @Override
                public void doExecute() throws KeeperException, InterruptedException {
                    String appId = context.getAppId();
                    final String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, 0).toString();
                    new BasicCoordinator.RetryCoordinatorCommand(NettyWorkerCoordinator.this.isFixedTime(), NettyWorkerCoordinator.this.getSleepTime()){
                        String newServerAddress;
                        {
                            super(x0, x1);
                            this.newServerAddress = null;
                        }

                        @Override
                        public boolean retryExecution() throws KeeperException, InterruptedException {
                            try {
                                boolean isServerChanged;
                                this.newServerAddress = new String(NettyWorkerCoordinator.this.getBytesFromZNode(appMasterNode, null), Charset.forName("UTF-8"));
                                boolean bl = isServerChanged = !this.newServerAddress.equals(NettyWorkerCoordinator.this.masterServerAddress);
                                if (isServerChanged) {
                                    NettyWorkerCoordinator.this.masterServerAddress = this.newServerAddress;
                                }
                                return isServerChanged;
                            }
                            catch (KeeperException.NoNodeException e) {
                                if (System.nanoTime() % 10L == 0L) {
                                    LOG.warn("No such node:{}", (Object)appMasterNode);
                                }
                                return false;
                            }
                        }
                    }.execute();
                }
            }.execute();
            this.connectMasterServer();
            if (!context.isInitIteration()) {
                new BasicCoordinator.BasicCoordinatorCommand(){

                    @Override
                    public void doExecute() throws KeeperException, InterruptedException {
                        String appId = context.getAppId();
                        int lastIteration = context.getCurrentIteration();
                        String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, lastIteration).toString();
                        String appMasterSplitNode = NettyWorkerCoordinator.this.getCurrentMasterSplitNode(appId, lastIteration).toString();
                        NettyWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                    }
                }.execute();
            }
            context.setCurrentIteration(context.getCurrentIteration() + 1);
            this.isServerShutdown.compareAndSet(true, false);
        }
        LOG.info("Start itertion {} with container id {} and app id {}.", new Object[]{context.getCurrentIteration(), context.getContainerId(), context.getAppId()});
    }

    @Override
    public void postIteration(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appId = context.getAppId();
                int currentIteration = context.getCurrentIteration();
                final String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                BytableWrapper workerMessage = new BytableWrapper();
                workerMessage.setBytes(NettyWorkerCoordinator.this.getWorkerSerializer().objectToBytes(context.getWorkerResult()));
                workerMessage.setCurrentIteration(context.getCurrentIteration());
                workerMessage.setContainerId(context.getContainerId());
                workerMessage.setStopMessage(false);
                LOG.debug("Message:{}", (Object)workerMessage);
                NettyWorkerCoordinator.this.clientChannel.write((Object)workerMessage);
                long start = System.nanoTime();
                new BasicCoordinator.RetryCoordinatorCommand(NettyWorkerCoordinator.this.isFixedTime(), NettyWorkerCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        try {
                            return NettyWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, false) != null || NettyWorkerCoordinator.this.isServerShutdown.get();
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 10L == 0L) {
                                LOG.warn("No such node:{}", (Object)appMasterNode);
                            }
                            return false;
                        }
                    }
                }.execute();
                LOG.info("Application {} container {} iteration {} waiting ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
                if (!NettyWorkerCoordinator.this.isServerShutdown.get()) {
                    String appMasterSplitNode = NettyWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                    NettyWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                    LOG.info("Master computation is done.");
                }
            }
        }.execute();
    }

    @Override
    public void postApplication(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doExecute() throws Exception, InterruptedException {
                try {
                    BytableWrapper stopMessage = new BytableWrapper();
                    stopMessage.setCurrentIteration(context.getCurrentIteration());
                    stopMessage.setContainerId(context.getContainerId());
                    stopMessage.setStopMessage(true);
                    ChannelFuture future = NettyWorkerCoordinator.this.clientChannel.write((Object)stopMessage);
                    future.await(30L, TimeUnit.SECONDS);
                }
                finally {
                    NettyWorkerCoordinator.this.clientChannel.close();
                    Method shutDownMethod = ReflectionUtils.getMethod(NettyWorkerCoordinator.this.messageClient.getClass(), "shutdown");
                    if (shutDownMethod != null) {
                        shutDownMethod.invoke((Object)NettyWorkerCoordinator.this.messageClient, (Object[])null);
                    }
                    NettyWorkerCoordinator.this.messageClient.releaseExternalResources();
                    NettyWorkerCoordinator.this.closeZooKeeper();
                }
            }
        }.execute();
    }

    private class ClientHandler
    extends SimpleChannelUpstreamHandler {
        private ClientHandler() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            super.handleUpstream(ctx, e);
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            LOG.info("Channel connected:{}", e.getValue());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            LOG.info("Receive status:{}", e.getMessage());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            e.getChannel().close();
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            LOG.info("Master server is down, channel client is disconnected with event {}", (Object)e);
            NettyWorkerCoordinator.this.isServerShutdown.compareAndSet(false, true);
        }
    }
}

