/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.util.concurrent.TimeUnit;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.worker.BasicWorkerInterceptor;
import ml.shifu.guagua.worker.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerTimer<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends BasicWorkerInterceptor<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerTimer.class);
    private long appStartTime;
    private long iterStartTime;

    @Override
    public void preApplication(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.appStartTime = System.nanoTime();
        LOG.info("Application {} container {} starts worker computation..", (Object)context.getAppId(), (Object)context.getContainerId());
    }

    @Override
    public void preIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.iterStartTime = System.nanoTime();
        LOG.info("Application {} container {} iteration {} starts worker computation.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration()});
    }

    @Override
    public void postIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} iteration {} ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.iterStartTime)});
    }

    @Override
    public void postApplication(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        LOG.info("Application {} container {} ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.appStartTime)});
    }
}

