/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.TrainingSetScore;
import org.encog.neural.networks.training.genetic.NeuralGeneticAlgorithm;
import org.encog.util.ParamsHolder;

public class GeneticFactory {
    public final MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof BasicNetwork)) {
            throw new TrainingError("Invalid method type, requires BasicNetwork");
        }
        TrainingSetScore score = new TrainingSetScore(training);
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        ParamsHolder holder = new ParamsHolder(args);
        int populationSize = holder.getInt("population", false, 5000);
        double mutation = holder.getDouble("mutate", false, 0.1);
        double mate = holder.getDouble("mate", false, 0.25);
        NeuralGeneticAlgorithm train = new NeuralGeneticAlgorithm((BasicNetwork)method, new RangeRandomizer(-1.0, 1.0), score, populationSize, mutation, mate);
        return train;
    }
}

