/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy;

import org.encog.ml.MLResettable;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.networks.training.TrainingError;
import org.encog.util.logging.EncogLogging;

public class RequiredImprovementStrategy
implements Strategy {
    private final double required;
    private final int cycles;
    private MLTrain train;
    private int badCycleCount;
    private double lastError = Double.NaN;
    private double acceptableThreshold;
    private MLResettable method;

    public RequiredImprovementStrategy(double required, int cycles) {
        this(required, 0.1, cycles);
    }

    public RequiredImprovementStrategy(double required, double threshold, int cycles) {
        this.required = required;
        this.cycles = cycles;
        this.badCycleCount = 0;
        this.acceptableThreshold = threshold;
    }

    public RequiredImprovementStrategy(int cycles) {
        this(0.01, 0.1, cycles);
    }

    @Override
    public void init(MLTrain train) {
        this.train = train;
        if (!(train.getMethod() instanceof MLResettable)) {
            throw new TrainingError("To use the required improvement strategy the machine learning method must support MLResettable.");
        }
        this.method = (MLResettable)this.train.getMethod();
    }

    @Override
    public void postIteration() {
    }

    @Override
    public void preIteration() {
        if (this.train.getError() > this.acceptableThreshold) {
            if (!Double.isNaN(this.lastError)) {
                double improve = this.lastError - this.train.getError();
                if (improve < this.required) {
                    ++this.badCycleCount;
                    if (this.badCycleCount > this.cycles) {
                        EncogLogging.log(0, "Failed to improve network, resetting.");
                        this.method.reset();
                        this.badCycleCount = 0;
                        this.lastError = Double.NaN;
                    }
                } else {
                    this.badCycleCount = 0;
                }
            } else {
                this.lastError = this.train.getError();
            }
        }
        this.lastError = Math.min(this.train.getError(), this.lastError);
    }
}

