/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.ml.BasicML;
import org.encog.ml.MLContext;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.neat.NEATLink;
import org.encog.neural.neat.NEATNeuron;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.util.simple.EncogUtility;

public class NEATNetwork
extends BasicML
implements MLContext,
MLRegression,
MLError {
    private static final long serialVersionUID = 3660295468309926508L;
    public static final String PROPERTY_NETWORK_DEPTH = "depth";
    public static final String PROPERTY_LINKS = "links";
    public static final String PROPERTY_SNAPSHOT = "snapshot";
    private ActivationFunction activationFunction;
    private ActivationFunction outputActivationFunction;
    private int networkDepth;
    private final List<NEATNeuron> neurons = new ArrayList<NEATNeuron>();
    private boolean snapshot = false;
    private int inputCount;
    private int outputCount;

    public NEATNetwork() {
    }

    public NEATNetwork(int inputCount, int outputCount, List<NEATNeuron> neurons, ActivationFunction activationFunction, ActivationFunction outputActivationFunction, int networkDepth) {
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.outputActivationFunction = outputActivationFunction;
        this.neurons.addAll(neurons);
        this.networkDepth = networkDepth;
        this.activationFunction = activationFunction;
    }

    public NEATNetwork(int inputCount, int outputCount) {
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.networkDepth = 0;
        this.activationFunction = new ActivationSigmoid();
    }

    @Override
    public void clearContext() {
        for (NEATNeuron neuron : this.neurons) {
            neuron.setOutput(0.0);
        }
    }

    @Override
    public MLData compute(MLData input) {
        BasicMLData result = new BasicMLData(this.outputCount);
        if (this.neurons.size() == 0) {
            throw new NeuralNetworkError("This network has not been evolved yet, it has no neurons in the NEAT synapse.");
        }
        int flushCount = 1;
        if (this.snapshot) {
            flushCount = this.networkDepth;
        }
        for (int i = 0; i < flushCount; ++i) {
            int outputIndex = 0;
            int index = 0;
            result.clear();
            while (this.neurons.get(index).getNeuronType() == NEATNeuronType.Input) {
                this.neurons.get(index).setOutput(input.getData(index));
                ++index;
            }
            this.neurons.get(index++).setOutput(1.0);
            while (index < this.neurons.size()) {
                NEATNeuron currentNeuron = this.neurons.get(index);
                double sum = 0.0;
                for (NEATLink link : currentNeuron.getInboundLinks()) {
                    double weight = link.getWeight();
                    double neuronOutput = link.getFromNeuron().getOutput();
                    sum += weight * neuronOutput;
                }
                double[] d = new double[]{sum / currentNeuron.getActivationResponse()};
                this.activationFunction.activationFunction(d, 0, d.length);
                this.neurons.get(index).setOutput(d[0]);
                if (currentNeuron.getNeuronType() == NEATNeuronType.Output) {
                    result.setData(outputIndex++, currentNeuron.getOutput());
                }
                ++index;
            }
        }
        this.outputActivationFunction.activationFunction(result.getData(), 0, result.size());
        return result;
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public List<NEATNeuron> getNeurons() {
        return this.neurons;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public void updateProperties() {
    }

    public void setInputCount(int i) {
        this.inputCount = i;
    }

    public void setOutputCount(int i) {
        this.outputCount = i;
    }

    public void setNetworkDepth(int i) {
        this.networkDepth = i;
    }

    public ActivationFunction getOutputActivationFunction() {
        return this.outputActivationFunction;
    }

    public void setOutputActivationFunction(ActivationFunction outputActivationFunction) {
        this.outputActivationFunction = outputActivationFunction;
    }

    @Override
    public double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }
}

