/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.util.benchmark.RandomTrainingFactory;
import org.encog.util.simple.EncogUtility;

public final class Evaluate {
    public static final int MILIS = 1000;

    public static int evaluateTrain(int input, int hidden1, int hidden2, int output) {
        BasicNetwork network = EncogUtility.simpleFeedForward(input, hidden1, hidden2, output, true);
        BasicMLDataSet training = RandomTrainingFactory.generate(1000L, 10000, input, output, -1.0, 1.0);
        return Evaluate.evaluateTrain(network, training);
    }

    public static int evaluateTrain(BasicNetwork network, MLDataSet training) {
        ResilientPropagation train = new ResilientPropagation(network, training);
        long start = System.currentTimeMillis();
        long stop = start + 10000L;
        int iterations = 0;
        while (System.currentTimeMillis() < stop) {
            ++iterations;
            train.iteration();
        }
        return iterations;
    }
}

