/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.yarn.example.sum;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ml.shifu.guagua.hadoop.io.GuaguaSequenceRecordReader;
import ml.shifu.guagua.hadoop.io.GuaguaWritableAdapter;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.GuaguaRecordReader;
import ml.shifu.guagua.worker.AbstractWorkerComputable;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumSequenceFileWorker
extends AbstractWorkerComputable<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<Text>, GuaguaWritableAdapter<Text>> {
    private static final Logger LOG = LoggerFactory.getLogger(SumSequenceFileWorker.class);
    private List<Long> list;

    public void init(WorkerContext<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>> workerContext) {
        this.list = new LinkedList<Long>();
    }

    public GuaguaWritableAdapter<LongWritable> doCompute(WorkerContext<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>> workerContext) {
        long sum = workerContext.getLastMasterResult() == null ? 0L : ((LongWritable)((GuaguaWritableAdapter)workerContext.getLastMasterResult()).getWritable()).get();
        for (long longValue : this.list) {
            sum += longValue;
        }
        LOG.info("worker: {} ; sum: {}", workerContext, (Object)sum);
        return new GuaguaWritableAdapter((Writable)new LongWritable(sum));
    }

    public void load(GuaguaWritableAdapter<Text> currentKey, GuaguaWritableAdapter<Text> currentValue, WorkerContext<GuaguaWritableAdapter<LongWritable>, GuaguaWritableAdapter<LongWritable>> workerContext) {
        this.list.add(Long.parseLong(((Text)currentValue.getWritable()).toString()));
    }

    public void initRecordReader(GuaguaFileSplit fileSplit) throws IOException {
        this.setRecordReader((GuaguaRecordReader)new GuaguaSequenceRecordReader(fileSplit, Text.class, Text.class));
    }
}

