/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.buffer.codec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.encog.ml.data.buffer.BufferedDataError;
import org.encog.ml.data.buffer.codec.DataSetCODEC;
import org.encog.util.EngineArray;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.csv.ReadCSV;

public class CSVDataCODEC
implements DataSetCODEC {
    private final File file;
    private final CSVFormat format;
    private int inputCount;
    private int idealCount;
    private boolean headers;
    private ReadCSV readCSV;
    private PrintStream output;
    private boolean expectSignificance;

    public CSVDataCODEC(File theFile, CSVFormat theFormat, boolean theExpectSignificance) {
        this.file = theFile;
        this.format = theFormat;
        this.expectSignificance = theExpectSignificance;
    }

    public CSVDataCODEC(File theFile, CSVFormat theFormat, boolean theHeaders, int theInputCount, int theIdealCount, boolean theExpectSignificance) {
        if (this.inputCount != 0) {
            throw new BufferedDataError("To export CSV, you must use the CSVDataCODEC constructor that does not specify input or ideal sizes.");
        }
        this.file = theFile;
        this.format = theFormat;
        this.inputCount = theInputCount;
        this.idealCount = theIdealCount;
        this.headers = theHeaders;
        this.expectSignificance = theExpectSignificance;
    }

    @Override
    public final void close() {
        if (this.readCSV != null) {
            this.readCSV.close();
            this.readCSV = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }

    @Override
    public final int getIdealSize() {
        return this.idealCount;
    }

    @Override
    public final int getInputSize() {
        return this.inputCount;
    }

    @Override
    public final void prepareRead() {
        if (this.inputCount == 0) {
            throw new BufferedDataError("To import CSV, you must use the CSVDataCODEC constructor that specifies input and ideal sizes.");
        }
        this.readCSV = new ReadCSV(this.file.toString(), this.headers, this.format);
    }

    @Override
    public final void prepareWrite(int recordCount, int inputSize, int idealSize) {
        try {
            this.inputCount = inputSize;
            this.idealCount = idealSize;
            this.output = new PrintStream(new FileOutputStream(this.file));
        }
        catch (IOException ex) {
            throw new BufferedDataError(ex);
        }
    }

    @Override
    public final boolean read(double[] input, double[] ideal, double[] significance) {
        if (this.readCSV.next()) {
            int i;
            int index = 0;
            for (i = 0; i < input.length; ++i) {
                input[i] = this.readCSV.getDouble(index++);
            }
            for (i = 0; i < ideal.length; ++i) {
                ideal[i] = this.readCSV.getDouble(index++);
            }
            significance[0] = this.expectSignificance ? this.readCSV.getDouble(index++) : 1.0;
            return true;
        }
        return false;
    }

    @Override
    public final void write(double[] input, double[] ideal, double significance) {
        if (this.expectSignificance) {
            double[] record = new double[input.length + ideal.length + 1];
            EngineArray.arrayCopy(input, record);
            EngineArray.arrayCopy(ideal, 0, record, input.length, ideal.length);
            record[record.length - 1] = significance;
            StringBuilder result = new StringBuilder();
            NumberList.toList(this.format, result, record);
            this.output.println(result.toString());
        } else {
            double[] record = new double[input.length + ideal.length];
            EngineArray.arrayCopy(input, record);
            EngineArray.arrayCopy(ideal, 0, record, input.length, ideal.length);
            StringBuilder result = new StringBuilder();
            NumberList.toList(this.format, result, record);
            this.output.println(result.toString());
        }
    }
}

