/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.method;

import java.util.List;
import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.ml.MLMethod;
import org.encog.ml.factory.MLActivationFactory;
import org.encog.ml.factory.parse.ArchitectureLayer;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;

public class FeedforwardFactory {
    public static final String CANT_DEFINE_ACT = "Can't define activation function before first layer.";
    private MLActivationFactory factory = new MLActivationFactory();

    public final MLMethod create(String architecture, int input, int output) {
        if (input <= 0) {
            throw new EncogError("Must have at least one input for feedforward.");
        }
        if (output <= 0) {
            throw new EncogError("Must have at least one output for feedforward.");
        }
        BasicNetwork result = new BasicNetwork();
        List<String> layers = ArchitectureParse.parseLayers(architecture);
        ActivationFunction af = new ActivationLinear();
        int questionPhase = 0;
        for (String layerStr : layers) {
            int defaultCount = questionPhase == 0 ? input : output;
            ArchitectureLayer layer = ArchitectureParse.parseLayer(layerStr, defaultCount);
            boolean bias = layer.isBias();
            String part = layer.getName();
            ActivationFunction lookup = this.factory.create(part = part != null ? part.trim() : "");
            if (lookup != null) {
                af = lookup;
                continue;
            }
            if (layer.isUsedDefault() && ++questionPhase > 2) {
                throw new EncogError("Only two ?'s may be used.");
            }
            if (layer.getCount() == 0) {
                throw new EncogError("Unknown architecture element: " + architecture + ", can't parse: " + part);
            }
            result.addLayer(new BasicLayer(af, bias, layer.getCount()));
        }
        result.getStructure().finalizeStructure();
        result.reset();
        return result;
    }
}

