/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.GuaguaFileSplit;
import ml.shifu.guagua.io.GuaguaRecordReader;
import ml.shifu.guagua.worker.WorkerComputable;
import ml.shifu.guagua.worker.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCombineWorkerComputable<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable, KEY extends Bytable, VALUE extends Bytable>
implements WorkerComputable<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCombineWorkerComputable.class);
    private AtomicBoolean isLoaded = new AtomicBoolean(false);
    private GuaguaRecordReader<KEY, VALUE> recordReader;
    private Map<KEY, VALUE> dataMap = null;

    protected AbstractCombineWorkerComputable() {
        this(false);
    }

    protected AbstractCombineWorkerComputable(boolean isOrder) {
        this.dataMap = isOrder ? new TreeMap<KEY, VALUE>() : new HashMap<KEY, VALUE>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WORKER_RESULT compute(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) throws IOException {
        if (context.isFirstIteration()) {
            if (!this.isLoaded.compareAndSet(false, true)) return context.getWorkerResult();
            this.init(context);
            long start2 = System.nanoTime();
            this.preLoad(context);
            long count = 0L;
            for (GuaguaFileSplit fileSplit : context.getFileSplits()) {
                LOG.info("Loading filesplit: {}", (Object)fileSplit);
                try {
                    this.initRecordReader(fileSplit);
                    while (this.getRecordReader().nextKeyValue()) {
                        KEY currentKey = this.getRecordReader().getCurrentKey();
                        VALUE currentValue = this.getRecordReader().getCurrentValue();
                        this.doCompute(currentKey, currentValue, context);
                        this.dataMap.put(currentKey, currentValue);
                        ++count;
                    }
                }
                finally {
                    if (this.getRecordReader() == null) continue;
                    this.getRecordReader().close();
                }
            }
            this.postLoad(context);
            LOG.info("Load {} records.", (Object)count);
            LOG.info("Data loading time with first iteration computing:{}ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2));
            return context.getWorkerResult();
        }
        long start = System.nanoTime();
        try {
            for (Map.Entry<KEY, VALUE> entry : this.dataMap.entrySet()) {
                this.doCompute((Bytable)entry.getKey(), (Bytable)entry.getValue(), context);
            }
        }
        catch (Throwable throwable) {
            LOG.info("Computation time for application {} container {} iteration {}: {}ms.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
            throw throwable;
        }
        LOG.info("Computation time for application {} container {} iteration {}: {}ms.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
        return context.getWorkerResult();
    }

    protected void preLoad(WorkerContext<MASTER_RESULT, WORKER_RESULT> workerContext) {
    }

    protected void postLoad(WorkerContext<MASTER_RESULT, WORKER_RESULT> workerContext) {
    }

    public abstract void initRecordReader(GuaguaFileSplit var1) throws IOException;

    public abstract void init(WorkerContext<MASTER_RESULT, WORKER_RESULT> var1);

    public abstract void doCompute(KEY var1, VALUE var2, WorkerContext<MASTER_RESULT, WORKER_RESULT> var3);

    public GuaguaRecordReader<KEY, VALUE> getRecordReader() {
        return this.recordReader;
    }

    public void setRecordReader(GuaguaRecordReader<KEY, VALUE> recordReader) {
        this.recordReader = recordReader;
    }
}

