/*
 * Decompiled with CFR 0.152.
 */
package ml.shifu.guagua.worker;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import ml.shifu.guagua.BasicCoordinator;
import ml.shifu.guagua.GuaguaRuntimeException;
import ml.shifu.guagua.coordinator.zk.GuaguaZooKeeper;
import ml.shifu.guagua.io.Bytable;
import ml.shifu.guagua.io.BytableWrapper;
import ml.shifu.guagua.io.HaltBytable;
import ml.shifu.guagua.io.NettyBytableDecoder;
import ml.shifu.guagua.io.NettyBytableEncoder;
import ml.shifu.guagua.util.NumberFormatUtils;
import ml.shifu.guagua.util.ReflectionUtils;
import ml.shifu.guagua.worker.AbstractWorkerCoordinator;
import ml.shifu.guagua.worker.WorkerContext;
import org.apache.zookeeper.KeeperException;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWorkerCoordinator<MASTER_RESULT extends Bytable, WORKER_RESULT extends Bytable>
extends AbstractWorkerCoordinator<MASTER_RESULT, WORKER_RESULT> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyWorkerCoordinator.class);
    private static final long GUAGUA_DEFAULT_WORKER_GETRESULT_TIMEOUT = 60000L;
    private static final String GUAGUA_WORKER_GETRESULT_TIMEOUT = "guagua.worker.getresult.timeout";
    private String masterServerAddress;
    private ClientBootstrap messageClient;
    private Channel clientChannel;
    private AtomicBoolean isServerShutdownOrClientDisconnect = new AtomicBoolean(false);
    private boolean isTimeoutToGetCurrentMasterResult = false;
    private boolean isMasterZnodeCleaned = false;
    private boolean isTimeoutToGetMasterServerAddress = false;

    @Override
    public void preApplication(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        this.initialize(context.getProps());
        new AbstractWorkerCoordinator.FailOverCoordinatorCommand(context).execute();
        new BasicCoordinator.BasicCoordinatorCommand(){

            @Override
            public void doExecute() throws KeeperException, InterruptedException {
                String appId = context.getAppId();
                final String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, 0).toString();
                new BasicCoordinator.RetryCoordinatorCommand(NettyWorkerCoordinator.this.isFixedTime(), NettyWorkerCoordinator.this.getSleepTime()){

                    @Override
                    public boolean retryExecution() throws KeeperException, InterruptedException {
                        try {
                            return NettyWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, false) != null;
                        }
                        catch (KeeperException.NoNodeException e) {
                            if (System.nanoTime() % 10L == 0L) {
                                LOG.warn("No such node:{}", (Object)appMasterNode);
                            }
                            return false;
                        }
                    }
                }.execute();
                NettyWorkerCoordinator.this.masterServerAddress = new String(NettyWorkerCoordinator.this.getBytesFromZNode(appMasterNode, null), Charset.forName("UTF-8"));
            }
        }.execute();
        this.connectMasterServer();
        if (!context.isInitIteration()) {
            new BasicCoordinator.BasicCoordinatorCommand(){

                @Override
                public void doExecute() throws KeeperException, InterruptedException {
                    String appId = context.getAppId();
                    int currentIteration = context.getCurrentIteration();
                    String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                    String appMasterSplitNode = NettyWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                    NettyWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                }
            }.execute();
        }
    }

    private void connectMasterServer() {
        this.messageClient = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newSingleThreadExecutor(), (Executor)Executors.newSingleThreadExecutor()));
        this.messageClient.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new NettyBytableEncoder(), new NettyBytableDecoder(), new ClientHandler()});
            }
        });
        String[] namePortGroup = this.masterServerAddress.split(":");
        String masterServerName = namePortGroup[0];
        int masterServerPort = NumberFormatUtils.getInt(namePortGroup[1]);
        ChannelFuture future = this.messageClient.connect((SocketAddress)new InetSocketAddress(masterServerName, masterServerPort));
        this.clientChannel = future.awaitUninterruptibly().getChannel();
        LOG.info("Connect to {}:{}", (Object)masterServerName, (Object)masterServerPort);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void preIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void postIteration(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        final long timeOutThreshold = NumberFormatUtils.getLong(context.getProps().getProperty(GUAGUA_WORKER_GETRESULT_TIMEOUT), 60000L);
        while (true) {
            this.isTimeoutToGetCurrentMasterResult = false;
            this.isMasterZnodeCleaned = false;
            int latestIteraton = this.getLatestMasterIteration(context);
            if (context.getCurrentIteration() == latestIteraton + 1 && context.getCurrentIteration() <= context.getTotalIteration()) {
                new BasicCoordinator.BasicCoordinatorCommand(){

                    @Override
                    public void doExecute() throws KeeperException, InterruptedException {
                        String appId = context.getAppId();
                        int currentIteration = context.getCurrentIteration();
                        final String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, currentIteration).toString();
                        BytableWrapper workerMessage = new BytableWrapper();
                        workerMessage.setBytes(NettyWorkerCoordinator.this.getWorkerSerializer().objectToBytes(context.getWorkerResult()));
                        workerMessage.setCurrentIteration(context.getCurrentIteration());
                        workerMessage.setContainerId(context.getContainerId());
                        workerMessage.setStopMessage(false);
                        LOG.debug("Message:{}", (Object)workerMessage);
                        NettyWorkerCoordinator.this.clientChannel.write((Object)workerMessage);
                        final long start = System.nanoTime();
                        new BasicCoordinator.RetryCoordinatorCommand(NettyWorkerCoordinator.this.isFixedTime(), NettyWorkerCoordinator.this.getSleepTime()){

                            @Override
                            public boolean retryExecution() throws KeeperException, InterruptedException {
                                try {
                                    if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) >= timeOutThreshold) {
                                        NettyWorkerCoordinator.this.isTimeoutToGetCurrentMasterResult = true;
                                        return true;
                                    }
                                    return NettyWorkerCoordinator.this.getZooKeeper().exists(appMasterNode, false) != null || NettyWorkerCoordinator.this.isServerShutdownOrClientDisconnect.get();
                                }
                                catch (KeeperException.NoNodeException e) {
                                    if (System.nanoTime() % 10L == 0L) {
                                        LOG.warn("No such node:{}", (Object)appMasterNode);
                                    }
                                    return false;
                                }
                            }
                        }.execute();
                        if (!NettyWorkerCoordinator.this.isTimeoutToGetCurrentMasterResult) {
                            LOG.info("Application {} container {} iteration {} waiting ends with {}ms execution time.", new Object[]{context.getAppId(), context.getContainerId(), context.getCurrentIteration(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
                            if (!NettyWorkerCoordinator.this.isServerShutdownOrClientDisconnect.get()) {
                                String appMasterSplitNode = NettyWorkerCoordinator.this.getCurrentMasterSplitNode(appId, currentIteration).toString();
                                try {
                                    NettyWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                                }
                                catch (KeeperException.NoNodeException e) {
                                    NettyWorkerCoordinator.this.isMasterZnodeCleaned = true;
                                    LOG.warn("No such node:{}", (Object)appMasterNode);
                                }
                                LOG.info("Master computation is done.");
                            }
                        }
                    }
                }.execute();
                if (!this.isTimeoutToGetCurrentMasterResult && !this.isMasterZnodeCleaned) break;
                continue;
            }
            LOG.info("Application {} container {}, current iteration is switched to {}.", new Object[]{context.getAppId(), context.getContainerId(), latestIteraton});
            context.setCurrentIteration(latestIteraton);
            if (!context.isInitIteration()) {
                new BasicCoordinator.BasicCoordinatorCommand(){

                    @Override
                    public void doExecute() throws KeeperException, InterruptedException {
                        String appId = context.getAppId();
                        int lastIteration = context.getCurrentIteration();
                        String appMasterNode = NettyWorkerCoordinator.this.getCurrentMasterNode(appId, lastIteration).toString();
                        String appMasterSplitNode = NettyWorkerCoordinator.this.getCurrentMasterSplitNode(appId, lastIteration).toString();
                        try {
                            NettyWorkerCoordinator.this.setMasterResult(context, appMasterNode, appMasterSplitNode);
                        }
                        catch (KeeperException.NoNodeException e) {
                            NettyWorkerCoordinator.this.isMasterZnodeCleaned = true;
                            LOG.warn("No such node:{}", (Object)appMasterNode);
                        }
                    }
                }.execute();
            }
            if (!this.isMasterZnodeCleaned) break;
        }
    }

    @Override
    public void postApplication(final WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        new BasicCoordinator.BasicCoordinatorCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doExecute() throws Exception, InterruptedException {
                try {
                    Object masterResult = context.getLastMasterResult();
                    if (context.getCurrentIteration() == context.getTotalIteration() + 1 || masterResult instanceof HaltBytable && ((HaltBytable)masterResult).isHalt()) {
                        BytableWrapper stopMessage = new BytableWrapper();
                        stopMessage.setCurrentIteration(context.getCurrentIteration());
                        stopMessage.setContainerId(context.getContainerId());
                        stopMessage.setStopMessage(true);
                        ChannelFuture future = NettyWorkerCoordinator.this.clientChannel.write((Object)stopMessage);
                        future.await(30L, TimeUnit.SECONDS);
                        Thread.sleep(2000L);
                    }
                }
                finally {
                    NettyWorkerCoordinator.this.clientChannel.close();
                    Method shutDownMethod = ReflectionUtils.getMethod(NettyWorkerCoordinator.this.messageClient.getClass(), "shutdown");
                    if (shutDownMethod != null) {
                        shutDownMethod.invoke((Object)NettyWorkerCoordinator.this.messageClient, (Object[])null);
                    }
                    NettyWorkerCoordinator.this.messageClient.releaseExternalResources();
                    NettyWorkerCoordinator.this.closeZooKeeper();
                }
            }
        }.execute();
    }

    private int getLatestMasterIteration(WorkerContext<MASTER_RESULT, WORKER_RESULT> context) {
        try {
            String masterBaseNode = this.getMasterBaseNode(context.getAppId()).toString();
            List<String> masterIterations = null;
            try {
                masterIterations = this.getZooKeeper().getChildrenExt(masterBaseNode, false, false, false, new GuaguaZooKeeper.Filter(){

                    @Override
                    public boolean filter(String path) {
                        try {
                            Integer.parseInt(path);
                            return false;
                        }
                        catch (Exception e) {
                            return true;
                        }
                    }
                });
            }
            catch (KeeperException.NoNodeException e) {
                LOG.warn("No such node:{}", (Object)masterBaseNode);
            }
            if (masterIterations != null && masterIterations.size() > 0) {
                Collections.sort(masterIterations, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
                    }
                });
                LOG.info("DEBUG: master children:{}", masterIterations);
                try {
                    return Integer.valueOf(masterIterations.get(masterIterations.size() - 1));
                }
                catch (NumberFormatException e) {
                    throw new GuaguaRuntimeException(e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new GuaguaRuntimeException(e);
        }
        throw new GuaguaRuntimeException("Cannot get valid latest master iteration.");
    }

    private class ClientHandler
    extends SimpleChannelUpstreamHandler {
        private ClientHandler() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            super.handleUpstream(ctx, e);
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            LOG.info("Channel connected:{}", e.getValue());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            LOG.info("Receive status:{}", e.getMessage());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            e.getChannel().close();
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            LOG.info("Master server is down or channel client is disconnected with event {}", (Object)e);
            NettyWorkerCoordinator.this.isServerShutdownOrClientDisconnect.compareAndSet(false, true);
        }
    }
}

