/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.util.EngineArray;

public class TimeSeriesUtil {
    private final int lagDepth;
    private final int leadDepth;
    private final int totalDepth;
    private final EncogAnalyst analyst;
    private final int inputSize;
    private final int outputSize;
    private final List<double[]> buffer = new ArrayList<double[]>();
    private final Map<String, Integer> headingMap = new HashMap<String, Integer>();

    public TimeSeriesUtil(EncogAnalyst theAnalyst, boolean includeOutput, List<String> headings) {
        this.analyst = theAnalyst;
        this.lagDepth = this.analyst.getLagDepth();
        this.leadDepth = this.analyst.getLeadDepth();
        this.totalDepth = this.lagDepth + this.leadDepth + 1;
        this.inputSize = includeOutput ? this.analyst.determineTotalColumns() : this.analyst.determineTotalInputFieldCount();
        this.outputSize = this.analyst.determineInputCount() + this.analyst.determineOutputCount();
        int headingIndex = 0;
        for (String column : headings) {
            this.headingMap.put(column, headingIndex++);
        }
    }

    public final EncogAnalyst getAnalyst() {
        return this.analyst;
    }

    public final List<double[]> getBuffer() {
        return this.buffer;
    }

    public final Map<String, Integer> getHeadingMap() {
        return this.headingMap;
    }

    public final int getInputSize() {
        return this.inputSize;
    }

    public final int getLagDepth() {
        return this.lagDepth;
    }

    public final int getLeadDepth() {
        return this.leadDepth;
    }

    public final int getOutputSize() {
        return this.outputSize;
    }

    public final int getTotalDepth() {
        return this.totalDepth;
    }

    public final double[] process(double[] input) {
        if (input.length != this.inputSize) {
            throw new AnalystError("Invalid input size: " + input.length + ", should be " + this.inputSize);
        }
        this.buffer.add(0, EngineArray.arrayCopy(input));
        if (this.buffer.size() < this.totalDepth) {
            return null;
        }
        double[] output = new double[this.outputSize];
        int outputIndex = 0;
        for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            if (field.isIgnored()) continue;
            if (!this.headingMap.containsKey(field.getName())) {
                throw new AnalystError("Undefined field: " + field.getName());
            }
            int headingIndex = this.headingMap.get(field.getName());
            int timeslice = this.translateTimeSlice(field.getTimeSlice());
            double[] row = this.buffer.get(timeslice);
            double d = row[headingIndex];
            output[outputIndex++] = d;
        }
        while (this.buffer.size() > this.totalDepth) {
            this.buffer.remove(this.buffer.size() - 1);
        }
        return output;
    }

    private int translateTimeSlice(int index) {
        return Math.abs(index - this.leadDepth);
    }
}

