/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.util.ParamsHolder;

public class RPROPFactory {
    public final MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof ContainsFlat)) {
            throw new EncogError("RPROP training cannot be used on a method of type: " + method.getClass().getName());
        }
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        ParamsHolder holder = new ParamsHolder(args);
        double initialUpdate = holder.getDouble("INIT_UPDATE", false, 0.1);
        double maxStep = holder.getDouble("MAX_STEP", false, 50.0);
        return new ResilientPropagation((ContainsFlat)method, training, initialUpdate, maxStep);
    }
}

