/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.flat;

import org.encog.engine.network.activation.ActivationFunction;

public class FlatLayer {
    private ActivationFunction activation;
    private final int count;
    private double biasActivation;
    private FlatLayer contextFedBy;

    public FlatLayer(ActivationFunction activation, int count, double biasActivation) {
        this.activation = activation;
        this.count = count;
        this.biasActivation = biasActivation;
        this.contextFedBy = null;
    }

    public final ActivationFunction getActivation() {
        return this.activation;
    }

    public final double getBiasActivation() {
        if (this.hasBias()) {
            return this.biasActivation;
        }
        return 0.0;
    }

    public final int getContextCount() {
        if (this.contextFedBy == null) {
            return 0;
        }
        return this.contextFedBy.getCount();
    }

    public final FlatLayer getContextFedBy() {
        return this.contextFedBy;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getTotalCount() {
        if (this.contextFedBy == null) {
            return this.getCount() + (this.hasBias() ? 1 : 0);
        }
        return this.getCount() + (this.hasBias() ? 1 : 0) + this.contextFedBy.getCount();
    }

    public final boolean hasBias() {
        return Math.abs(this.biasActivation) > 1.0E-13;
    }

    public final void setActivation(ActivationFunction activation) {
        this.activation = activation;
    }

    public void setBiasActivation(double a) {
        this.biasActivation = a;
    }

    public final void setContextFedBy(FlatLayer from) {
        this.contextFedBy = from;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        result.append(": count=");
        result.append(this.count);
        result.append(",bias=");
        if (this.hasBias()) {
            result.append(this.biasActivation);
        } else {
            result.append("false");
        }
        if (this.contextFedBy != null) {
            result.append(",contextFed=");
            if (this.contextFedBy == this) {
                result.append("itself");
            } else {
                result.append(this.contextFedBy);
            }
        }
        result.append("]");
        return result.toString();
    }
}

