/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;

public class ADALINEPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;

    @Override
    public final void addHiddenLayer(int count) {
        throw new PatternError("An ADALINE network has no hidden layers.");
    }

    @Override
    public final void clear() {
        this.inputNeurons = 0;
        this.outputNeurons = 0;
    }

    @Override
    public final MLMethod generate() {
        BasicNetwork network = new BasicNetwork();
        BasicLayer inputLayer = new BasicLayer((ActivationFunction)new ActivationLinear(), true, this.inputNeurons);
        BasicLayer outputLayer = new BasicLayer((ActivationFunction)new ActivationLinear(), false, this.outputNeurons);
        network.addLayer(inputLayer);
        network.addLayer(outputLayer);
        network.getStructure().finalizeStructure();
        new RangeRandomizer(-0.5, 0.5).randomize(network);
        return network;
    }

    @Override
    public final void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("A ADALINE network can't specify a custom activation function.");
    }

    @Override
    public final void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public final void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

