/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.simple;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.EncogError;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.mathutil.error.ErrorCalculation;
import org.encog.ml.MLClassification;
import org.encog.ml.MLContext;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.ml.data.buffer.MemoryDataLoader;
import org.encog.ml.data.buffer.codec.CSVDataCODEC;
import org.encog.ml.data.specific.CSVNeuralDataSet;
import org.encog.ml.svm.SVM;
import org.encog.ml.svm.training.SVMTrain;
import org.encog.ml.train.BasicTraining;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.ContainsFlat;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.neural.pattern.FeedForwardPattern;
import org.encog.util.Format;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public final class EncogUtility {
    public static void convertCSV2Binary(File csvFile, File binFile, int inputCount, int outputCount, boolean headers) {
        binFile.delete();
        CSVNeuralDataSet csv = new CSVNeuralDataSet(csvFile.toString(), inputCount, outputCount, false);
        BufferedMLDataSet buffer = new BufferedMLDataSet(binFile);
        buffer.beginLoad(inputCount, outputCount);
        for (MLDataPair pair : csv) {
            buffer.add(pair);
        }
        buffer.endLoad();
    }

    public static MLDataSet loadCSV2Memory(String filename, int input, int ideal, boolean headers, CSVFormat format, boolean significance) {
        CSVDataCODEC codec = new CSVDataCODEC(new File(filename), format, headers, input, ideal, significance);
        MemoryDataLoader load = new MemoryDataLoader(codec);
        MLDataSet dataset = load.external2Memory();
        return dataset;
    }

    public static void evaluate(MLRegression network, MLDataSet training) {
        for (MLDataPair pair : training) {
            MLData output = network.compute(pair.getInput());
            System.out.println("Input=" + EncogUtility.formatNeuralData(pair.getInput()) + ", Actual=" + EncogUtility.formatNeuralData(output) + ", Ideal=" + EncogUtility.formatNeuralData(pair.getIdeal()));
        }
    }

    public static String formatNeuralData(MLData data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            if (i != 0) {
                result.append(',');
            }
            result.append(Format.formatDouble(data.getData(i), 4));
        }
        return result.toString();
    }

    public static BasicNetwork simpleFeedForward(int input, int hidden1, int hidden2, int output, boolean tanh) {
        FeedForwardPattern pattern = new FeedForwardPattern();
        pattern.setInputNeurons(input);
        pattern.setOutputNeurons(output);
        if (tanh) {
            pattern.setActivationFunction(new ActivationTANH());
        } else {
            pattern.setActivationFunction(new ActivationSigmoid());
        }
        if (hidden1 > 0) {
            pattern.addHiddenLayer(hidden1);
        }
        if (hidden2 > 0) {
            pattern.addHiddenLayer(hidden2);
        }
        BasicNetwork network = (BasicNetwork)pattern.generate();
        network.reset();
        return network;
    }

    public static void trainConsole(BasicNetwork network, MLDataSet trainingSet, int minutes) {
        ResilientPropagation train = new ResilientPropagation(network, trainingSet);
        train.setThreadCount(0);
        EncogUtility.trainConsole(train, network, trainingSet, minutes);
    }

    public static void trainConsole(MLTrain train, BasicNetwork network, MLDataSet trainingSet, int minutes) {
        long remaining;
        System.out.println("Beginning training...");
        long start = System.currentTimeMillis();
        do {
            train.iteration();
            long current = System.currentTimeMillis();
            long elapsed = (current - start) / 1000L;
            remaining = (long)minutes - elapsed / 60L;
            int iteration = train.getIteration();
            System.out.println("Iteration #" + Format.formatInteger(iteration) + " Error:" + Format.formatPercent(train.getError()) + " elapsed time = " + Format.formatTimeSpan((int)elapsed) + " time left = " + Format.formatTimeSpan((int)remaining * 60));
        } while (remaining > 0L);
        train.finishTraining();
    }

    public static void trainToError(MLMethod method, MLDataSet dataSet, double error) {
        BasicTraining train = method instanceof SVM ? new SVMTrain((SVM)method, dataSet) : new ResilientPropagation((ContainsFlat)method, dataSet);
        EncogUtility.trainToError(train, error);
    }

    public static void trainToError(MLTrain train, double error) {
        int epoch = 1;
        System.out.println("Beginning training...");
        do {
            train.iteration();
            System.out.println("Iteration #" + Format.formatInteger(epoch) + " Error:" + Format.formatPercent(train.getError()) + " Target Error: " + Format.formatPercent(error));
            ++epoch;
        } while (train.getError() > error && !train.isTrainingDone());
        train.finishTraining();
    }

    private EncogUtility() {
    }

    public static MLDataSet loadEGB2Memory(File filename) {
        BufferedMLDataSet buffer = new BufferedMLDataSet(filename);
        return buffer.loadToMemory();
    }

    public static void convertCSV2Binary(String csvFile, String binFile, int inputCount, int outputCount, boolean headers) {
        new File(binFile).delete();
        CSVNeuralDataSet csv = new CSVNeuralDataSet(csvFile.toString(), inputCount, outputCount, headers);
        BufferedMLDataSet buffer = new BufferedMLDataSet(new File(binFile));
        buffer.beginLoad(inputCount, outputCount);
        for (MLDataPair pair : csv) {
            buffer.add(pair);
        }
        buffer.endLoad();
    }

    public static void convertCSV2Binary(File csvFile, CSVFormat format, File binFile, int[] input, int[] ideal, boolean headers) {
        binFile.delete();
        ReadCSV csv = new ReadCSV(csvFile.toString(), headers, format);
        BufferedMLDataSet buffer = new BufferedMLDataSet(binFile);
        buffer.beginLoad(input.length, ideal.length);
        while (csv.next()) {
            int i;
            BasicMLData inputData = new BasicMLData(input.length);
            BasicMLData idealData = new BasicMLData(ideal.length);
            for (i = 0; i < input.length; ++i) {
                inputData.setData(i, csv.getDouble(input[i]));
            }
            for (i = 0; i < ideal.length; ++i) {
                idealData.setData(i, csv.getDouble(ideal[i]));
            }
            buffer.add(inputData, idealData);
        }
        buffer.endLoad();
    }

    public static double calculateRegressionError(MLRegression method, MLDataSet data) {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        if (method instanceof MLContext) {
            ((MLContext)((Object)method)).clearContext();
        }
        for (MLDataPair pair : data) {
            MLData actual = method.compute(pair.getInput());
            errorCalculation.updateError(actual.getData(), pair.getIdeal().getData(), pair.getSignificance());
        }
        return errorCalculation.calculate();
    }

    public static void saveCSV(File targetFile, CSVFormat format, MLDataSet set) {
        try {
            FileWriter outFile = new FileWriter(targetFile);
            PrintWriter out = new PrintWriter(outFile);
            for (MLDataPair data : set) {
                double d;
                int i;
                StringBuilder line = new StringBuilder();
                for (i = 0; i < data.getInput().size(); ++i) {
                    d = data.getInput().getData(i);
                    BasicFile.appendSeparator(line, format);
                    line.append(format.format(d, 10));
                }
                for (i = 0; i < data.getIdeal().size(); ++i) {
                    d = data.getIdeal().getData(i);
                    BasicFile.appendSeparator(line, format);
                    line.append(format.format(d, 10));
                }
                out.println(line);
            }
            out.close();
            outFile.close();
        }
        catch (IOException ex) {
            throw new EncogError(ex);
        }
    }

    public static double calculateClassificationError(MLClassification method, MLDataSet data) {
        int total = 0;
        int correct = 0;
        for (MLDataPair pair : data) {
            int ideal = (int)pair.getIdeal().getData(0);
            int actual = method.classify(pair.getInput());
            if (actual == ideal) {
                ++correct;
            }
            ++total;
        }
        return (double)(total - correct) / (double)total;
    }

    public static void saveEGB(File f, MLDataSet data) {
        BufferedMLDataSet binary = new BufferedMLDataSet(f);
        binary.load(data);
        data.close();
    }
}

